<?php
require_once 'bootstrap/db.php';
require_once 'app/Models/UserType.php';

echo "<h2>User Type Permissions Debug</h2>";

$userType = new UserType();
$types = $userType->getAll();

foreach($types as $type) {
    echo "<h3>ID: {$type['id']} - {$type['name']}</h3>";
    echo "<p><strong>Raw JSON:</strong> " . htmlspecialchars($type['permissions']) . "</p>";
    
    if (is_array($type['permissions'])) {
        echo "<p><strong>Permissions Array:</strong></p>";
        echo "<pre>";
        print_r($type['permissions']);
        echo "</pre>";
        
        echo "<p><strong>Permission Count:</strong> " . count($type['permissions']) . "</p>";
    } else {
        echo "<p><strong>Permissions:</strong> Not an array</p>";
    }
    
    echo "<hr>";
}
?>
