<?php $title=__('stock.ingredient_stock', 'Ingredient Stock'); ob_start(); ?>

<?php if(isset($_SESSION['success'])): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <?=htmlspecialchars($_SESSION['success']); unset($_SESSION['success']);?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="d-flex justify-content-between align-items-center mb-4 flex-md-row flex-column">
    <h1 class="h3 mb-3">
        <i class="fas fa-warehouse"></i> <?= __('stock.ingredient_stock', 'Ingredient Stock') ?>
    </h1>
    <div class="gap-3 ">
        <a href="/samanta_crm/stock/ingredients?mode=ledger" class="btn btn-secondary mb-2">
            <i class="fas fa-list me-1"></i><?= __('stock.ledger_view', 'Ledger View') ?>
        </a>
        <a href="/samanta_crm/stock/ingredients?export=csv" class="btn btn-success mb-2">CSV</a>
        <a href="/samanta_crm/stock/ingredients?export=json" class="btn btn-success mb-2">JSON</a>
        <a href="/samanta_crm/stock/ingredients?export=xls" class="btn btn-success mb-2">Excel</a>
        <a href="/samanta_crm/stock/ingredients?print=1" target="_blank" class="btn btn-dark mb-2"><?= __('common.print', 'Print') ?></a>
    </div>
</div>

<div class="mb-3 d-flex gap-2 align-items-center">
    <button id="toggleCollapse" type="button" class="btn btn-outline-primary"><?= __('stock.collapse_rollback', 'Collapse Rollback') ?></button>
    <div class="form-check mb-0">
        <input class="form-check-input" type="checkbox" id="hideZeroRollback">
        <label class="form-check-label" for="hideZeroRollback"><?= __('stock.hide_zero_rollback', 'Hide zero rollback') ?></label>
    </div>
</div>
<div class="card mb-3">
	<div class="card-header py-2 d-flex justify-content-between align-items-center">
		<span class="small fw-bold"><i class="fas fa-plus-circle me-1"></i><?= __('stock.adjust_add_stock', 'Adjust / Add Stock') ?></span>
		<button class="btn btn-sm btn-outline-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#adjustFormWrap"><?= __('common.toggle', 'Toggle') ?></button>
	</div>
	<div class="collapse show" id="adjustFormWrap">
		<div class="card-body py-3">
			<form class="row g-2 align-items-end" method="post" action="/samanta_crm/storage/adjust">
				<div class="col-12 col-md-4">
					<label class="form-label small mb-1"><?= __('stock.ingredient', 'Ingredient') ?></label>
					<select name="ingredient_id" class="form-select" required>
						<option value=""><?= __('common.choose', 'Choose...') ?></option>
						<?php foreach($stock as $row): ?>
							<option value="<?=$row['id']?>"><?=htmlspecialchars($row['name'])?> (<?=htmlspecialchars($row['unit'])?>)</option>
						<?php endforeach; ?>
					</select>
				</div>
				<div class="col-6 col-md-2">
					<label class="form-label small mb-1"><?= __('stock.quantity', 'Quantity (+/-)') ?></label>
					<input type="text" name="quantity" class="form-control" placeholder="<?= __('stock.qty_placeholder', 'e.g. 5') ?>" required>
				</div>
				<div class="col-6 col-md-2">
					<label class="form-label small mb-1"><?= __('stock.location', 'Location') ?></label>
					<select name="location" class="form-select">
						<option value="MAIN">MAIN</option>
						<option value="ROLLBACK">ROLLBACK</option>
					</select>
				</div>
				<div class="col-12 col-md-3">
						<label class="form-label small mb-1"><?= __('stock.note', 'Note') ?></label>
						<input type="text" name="note" class="form-control" placeholder="<?= __('stock.note_placeholder', 'Optional note') ?>">
				</div>
				<div class="col-12 col-md-1 d-grid">
					<input type="hidden" name="reason" value="manual_adjust">
					<button class="btn btn-primary"><i class="fas fa-save"></i></button>
				</div>
			</form>
			<div class="small text-muted mt-2"><?= __('stock.adjust_help', 'Enter a positive number to add stock or a negative number to subtract.') ?></div>
		</div>
	</div>
</div>

<div class="card mb-3">
	<div class="card-header py-2">
		<span class="small fw-bold"><i class="fas fa-calendar-check me-1"></i><?= __('stock.apply_daily_usage', 'Apply Daily Usage') ?></span>
	</div>
	<div class="card-body py-3">
		<form method="post" action="/samanta_crm/stock/apply-daily" class="row g-2 align-items-end">
			<div class="col-auto">
				<label class="form-label small mb-1"><?= __('common.date', 'Date') ?></label>
				<input type="date" name="apply_date" value="<?=date('Y-m-d');?>" class="form-control">
			</div>
			<div class="col-auto">
				<button class="btn btn-primary"><?= __('stock.apply_daily_usage', 'Apply Daily Usage') ?></button>
			</div>
		</form>
	</div>
</div>

<div class="card">
	<div class="card-header py-2">
		<span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('stock.stock_levels', 'Stock Levels') ?></span>
	</div>
	<div class="card-body pt-0">
		<div class="table-responsive">
			<table class="table table-sm table-hover align-middle data-table mb-0" id="ingredientStockTable">
				<thead class="table-light">
					<tr>
						<th><?= __("stock.ingredient", "Ingredient") ?></th>
						<th class="d-none d-md-table-cell"><?= __("stock.location", "Location") ?></th>
						<th class="text-end"><?= __("stock.qty", "Qty") ?></th>
						<th class="d-none d-lg-table-cell"><?= __("common.unit", "Unit") ?></th>
						<th class="text-end"><?= __("common.actions", "Actions") ?></th>
					</tr>
				</thead>
		<tbody>
	<?php foreach($stock as $row): ?>
		<?php $mainQty = isset($row['main_stock']) ? (int)round($row['main_stock']) : (int)round($row['stock']); $rollbackQty = (int)round($row['rollback_stock'] ?? 0); ?>
		<tr class="main-row" data-ing="<?=$row['id']?>">
			<td>
				<strong class="small"><?= htmlspecialchars($row['name']); ?></strong>
				<!-- Mobile-only info (phones) -->
				<div class="d-md-none small text-muted mt-1">
					<span class="badge bg-primary me-1">MAIN</span>
					<span class="badge bg-secondary"><?= htmlspecialchars($row['unit']); ?></span>
				</div>
			</td>
			<td class="d-none d-md-table-cell"><span class="badge bg-primary">MAIN</span></td>
			<td class="text-end"><strong><?=$mainQty?></strong></td>
			<td class="d-none d-lg-table-cell"><?= htmlspecialchars($row['unit']); ?></td>
			<td class="text-end">
				<a class="btn btn-sm btn-outline-primary" href="/samanta_crm/ingredients/<?=$row['id'];?>/edit">
					<i class="fas fa-edit"></i><span class="d-none d-sm-inline ms-1"><?= __("common.edit", "Edit") ?></span>
				</a>
			</td>
		</tr>
		<tr class="rollback-row <?= $rollbackQty===0? 'zero-rollback':''; ?>" data-ing="<?=$row['id']?>">
			<td>
				<strong class="small"><?= htmlspecialchars($row['name']); ?></strong>
				<!-- Mobile-only info (phones) -->
				<div class="d-md-none small text-muted mt-1">
					<span class="badge bg-warning text-dark me-1">ROLLBACK</span>
					<span class="badge bg-secondary"><?= htmlspecialchars($row['unit']); ?></span>
				</div>
			</td>
			<td class="d-none d-md-table-cell"><span class="badge bg-warning text-dark">ROLLBACK</span></td>
			<td class="text-end"><strong><?=$rollbackQty?></strong></td>
			<td class="d-none d-lg-table-cell"><?= htmlspecialchars($row['unit']); ?></td>
			<td class="text-end">
				<form method="post" action="/samanta_crm/storage/merge-rollback" class="d-inline">
					<input type="hidden" name="ingredient_id" value="<?=$row['id'];?>">
					<button class="btn btn-outline-secondary btn-sm" <?=$rollbackQty===0?'disabled':'';?>>
						<i class="fas fa-merge"></i><span class="d-none d-sm-inline ms-1">Merge</span>
					</button>
				</form>
			</td>
		</tr>
	<?php endforeach; ?>
		</tbody>
		</table>
		</div>
	</div>
	<div class="card-footer py-2 d-flex justify-content-between align-items-center">
		<a href="/samanta_crm/stock/usage-history" class="btn btn-outline-primary">
			<i class="fas fa-history me-1"></i><?= __('stock.usage_history', 'Usage History') ?>
		</a>
		<div class="small text-muted">
			<?= __('common.total', 'Total') ?>: <?= count($stock) ?> <?= __('common.items', 'items') ?>
		</div>
	</div>
</div>
<script>
(function(){
	const btn=document.getElementById('toggleCollapse');
	const hideZeroCb=document.getElementById('hideZeroRollback');
	let collapsed=false;
	function apply(){
		document.querySelectorAll('.rollback-row').forEach(tr=>{
			const isZero=tr.classList.contains('zero-rollback');
			if(collapsed){
				tr.style.display = 'none';
			} else {
				tr.style.display = (hideZeroCb.checked && isZero)?'none':'';
			}
		});
	}
	btn.addEventListener('click',()=>{ collapsed=!collapsed; btn.textContent = collapsed? 'Expand Rollback':'Collapse Rollback'; apply(); });
	hideZeroCb.addEventListener('change',apply);
})();
</script>
<a href="/samanta_crm/stock/usage-history" class="btn btn-sm btn-outline-primary">Usage History</a>
</div>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
