<?php
require_once __DIR__ . '/../../../bootstrap/auth.php';
requireLogin();
ob_start();
$title = __('settings.title', 'System Settings');
?>
<div class="content">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-sliders-h me-2"></i><?= __('settings.title', 'System Settings') ?></h2>
    <a href="/samanta_crm/dashboard" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?></a>
  </div>
  <div class="row">
    <div class="col-md-8">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <span><i class="fas fa-cog me-1"></i><?= __('settings.general', 'General') ?></span>
          <button form="settingsForm" type="submit" class="btn btn-sm btn-primary"><i class="fas fa-save me-1"></i><?= __("common.save", "Save") ?></button>
        </div>
        <div class="card-body">
          <form id="settingsForm" method="POST" action="/samanta_crm/settings/save" enctype="multipart/form-data">
            <div class="mb-3">
              <label class="form-label"><?= __('settings.site_name', 'Site Name') ?></label>
              <input type="text" name="site_name" value="<?= htmlspecialchars($settings['site_name']) ?>" class="form-control" required>
            </div>
            <div class="mb-3" id="logoUpload">
              <label class="form-label"><?= __('settings.site_logo', 'Site Logo') ?></label>
              <?php if(!empty($settings['site_logo'])): ?>
                <div class="mb-2">
                  <img src="<?= htmlspecialchars($settings['site_logo']) ?>" alt="<?= __('settings.site_logo', 'Site Logo') ?>" style="max-height:120px" class="border p-1 bg-white">
                </div>
              <?php endif; ?>
              <input type="file" name="site_logo" accept="image/*" class="form-control">
              <div class="form-text"><?= __('settings.logo_info', 'Allowed: png, jpg, jpeg, gif, webp, svg. Recommended height ≤ 80px.') ?></div>
            </div>
            <div class="mb-3 form-check">
              <input type="checkbox" class="form-check-input" id="showNameLogo" name="show_site_name_with_logo" value="1" <?= $settings['show_site_name_with_logo']==='1'?'checked':'' ?>>
              <label class="form-check-label" for="showNameLogo"><?= __('settings.show_name_with_logo', 'Show site name next to logo') ?></label>
            </div>
            <div class="row g-3">
              <div class="col-md-4">
                <label class="form-label"><?= __('settings.default_language', 'Default Language') ?></label>
                <select name="default_language" class="form-select">
                  <?php foreach ($languages as $lang): ?>
                    <option value="<?= htmlspecialchars($lang['code']) ?>" <?= $lang['code']===$settings['default_language']?'selected':'' ?>><?= $lang['flag'] ?> <?= htmlspecialchars($lang['native_name'] ?: $lang['name']) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-4">
                <label class="form-label d-block"><?= __('settings.maintenance_mode', 'Maintenance Mode') ?></label>
                <div class="form-check form-switch">
                  <input class="form-check-input" type="checkbox" name="maintenance_mode" id="mmode" <?= $settings['maintenance_mode']==='1'?'checked':'' ?>>
                  <label class="form-check-label" for="mmode"><?= __('settings.enable', 'Enable') ?></label>
                </div>
              </div>
            </div>
            <div class="mt-3">
              <label class="form-label"><?= __('settings.maintenance_message', 'Maintenance Message') ?></label>
              <textarea name="maintenance_message" rows="3" class="form-control" placeholder="<?= __('settings.maintenance_placeholder', 'Shown to non-admin users when maintenance is active.') ?>"><?= htmlspecialchars($settings['maintenance_message']) ?></textarea>
            </div>
          </form>
        </div>
      </div>
    </div>
    <div class="col-md-4">
       <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle"></i> <?= __('dashboard.system_info', 'System Info') ?>
                </h5>
            </div>
            <div class="card-body">
                <ul class="list-unstyled">
                    <li><strong><?= __('dashboard.php_version', 'PHP Version') ?>:</strong> <?= PHP_VERSION ?></li>
                    <li><strong><?= __('dashboard.environment', 'Environment') ?>:</strong> <?= APP_ENV ?></li>
                    <li><strong><?= __('dashboard.server_time', 'Server Time') ?>:</strong> <?= date('Y-m-d H:i:s') ?></li>
                </ul>
            </div>
        </div>
        
      <div class="card mt-4">
        <div class="card-header">
          <span><i class="fas fa-info-circle me-1"></i><?= __('settings.about', 'About') ?></span>
        </div>
        <div class="card-body">
          <img src="/samanta_crm/assets/images/svg/favicon.svg" alt="osBakery CRM" style="max-height:140px" class="mb-3">
          <p>osBakery CRM v1.2.3</p>
          <p><?= __('settings.developed_by', 'Developed by NowAgency.pl') ?></p>
          <p>&copy; <?= date('Y') ?> NowAgency.pl. <?= __('settings.all_rights', 'All rights reserved.') ?></p>
          <a href="https://NowAgency.pl/" target="_blank" class="btn btn-sm btn-primary"><i class="fas fa-external-link-alt me-1"></i><?= __('settings.visit_website', 'Visit Website') ?></a>
        </div>
      </div>
  </div>
</div></div>
<?php $content = ob_get_clean(); include __DIR__ . '/../layout.php'; ?>
