<?php $title=__('restocks.title', 'Restocks'); ob_start(); ?>

<?php if(isset($_SESSION['success'])): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <?=htmlspecialchars($_SESSION['success']); unset($_SESSION['success']);?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="d-flex justify-content-between align-items-center mb-4 flex-column flex-md-row">
    <h1 class="h3 mb-4">
        <i class="fas fa-truck-loading"></i> <?= __('restocks.title', 'Restocks') ?>
    </h1>
    <div class="gap-3">
        <a href="/samanta_crm/restocks/create" class="btn btn-primary mb-2">
            <i class="fas fa-plus"></i> <?= __('restocks.create', 'New Restock') ?>
        </a>
        <a href="/samanta_crm/stock/ingredients" class="btn btn-outline-secondary mb-2">
            <i class="fas fa-warehouse me-1"></i><?= __('stock.title', 'Stock') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('restocks.restocks', 'Restocks') ?></span>
    </div>
    <div class="card-body pt-0">
        <div class="table-responsive">
            <table class="table table-sm table-hover align-middle data-table mb-0" id="restocksTable">
                <thead class="table-light">
                    <tr>
                        <th><?= __("common.date", "Date") ?></th>
                        <th>ID</th>
                        <th class="d-none d-md-table-cell"><?= __("restocks.supplier", "Supplier") ?></th>
                        <th class="d-none d-lg-table-cell"><?= __("common.summary", "Summary") ?></th>
                        <th class="d-none d-xl-table-cell"><?= __("common.notes", "Notes") ?></th>
                        <th class="text-end"><?= __("common.actions", "Actions") ?></th>
                    </tr>
                </thead>
            <tbody>
            <?php foreach($restocks as $r): ?>
                <?php $cnt=(int)($r['item_count']??0); ?>
                <tr>
                    <td class="text-nowrap small">
                        <strong><?=htmlspecialchars($r['restock_date']);?></strong>
                    </td>
                    <td>
                        <code class="small">#<?=$r['id'];?></code>
                        <!-- Mobile-only info (phones) -->
                        <div class="d-md-none small text-muted mt-1">
                            <?php if(!empty($r['supplier'])): ?>
                                <i class="fas fa-truck me-1"></i><?=htmlspecialchars($r['supplier']);?>
                            <?php endif; ?>
                            <span class="ms-2"><?= $cnt.' '.__("restocks.items", "items"); ?></span>
                        </div>
                    </td>
                    <td class="d-none d-md-table-cell"><?=htmlspecialchars($r['supplier']??'');?></td>
                    <td class="small text-muted d-none d-lg-table-cell">
                        <?= $cnt.' '.__("restocks.items", "items"); ?>
                    </td>
                    <td class="small d-none d-xl-table-cell"><?=htmlspecialchars($r['notes']);?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <a class="btn btn-outline-secondary" href="/samanta_crm/restocks/<?=$r['id'];?>" title="<?= __("common.view", "View") ?>">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a class="btn btn-outline-primary d-none d-sm-inline-block" href="/samanta_crm/restocks/<?=$r['id'];?>/edit" title="<?= __("common.edit", "Edit") ?>">
                                <i class="fas fa-edit"></i>
                            </a>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer py-2 d-flex justify-content-between align-items-center">
        <span></span>
        <div class="small text-muted">
            <?= __('common.total', 'Total') ?>: <?= count($restocks) ?> <?= __('common.items', 'items') ?>
        </div>
    </div>
</div>

<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
