<?php $title=__('restocks.edit', 'Edit Restock #').$restock['id']; ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-truck-loading"></i> <?= __('restocks.edit', 'Edit Restock') ?> #<?=$restock['id'];?>
    </h1>
    <div>
        <a href="/samanta_crm/restocks/<?=$restock['id'];?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-edit me-1"></i><?= __('restocks.restock_details', 'Restock Details') ?></span>
    </div>
    <div class="card-body">
        <form method="post" action="/samanta_crm/restocks/<?=$restock['id'];?>/update" id="restockForm">
            <div class="row mb-3 g-3">
                <div class="col-md-2">
                    <label class="form-label"><?= __('common.date', 'Date') ?></label>
                    <input type="date" name="restock_date" value="<?=htmlspecialchars($restock['restock_date']);?>" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label"><?= __('restocks.supplier', 'Supplier') ?></label>
                    <input type="text" name="supplier" value="<?=htmlspecialchars($restock['supplier']??'');?>" class="form-control">
                </div>
                <div class="col-md-7">
                    <label class="form-label"><?= __('common.notes', 'Notes') ?></label>
                    <input type="text" name="notes" value="<?=htmlspecialchars($restock['notes']??'');?>" class="form-control">
                </div>
            </div>
            
            <h6 class="mb-2"><?= __('restocks.items', 'Items') ?></h6>
            <table class="table table-sm table-hover align-middle mb-3" id="restock-items">
                <thead>
                    <tr>
                        <th><?= __('ingredients.title', 'Ingredient') ?></th>
                        <th style="width:100px"><?= __('units.title', 'Unit') ?></th>
                        <th style="width:140px"><?= __('common.quantity', 'Qty') ?></th>
                        <th style="width:140px"><?= __('common.location', 'Location') ?></th>
                        <th style="width:40px"></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach($items as $it): ?>
                    <tr>
                        <td>
                            <select name="item_ingredient_id[]" class="form-select" onchange="updateUnit(this)">
                                <?php foreach($ingredients as $ing): ?>
                                    <option value="<?=$ing['id'];?>" <?=$ing['id']==$it['ingredient_id']?'selected':'';?>>
                                        <?=htmlspecialchars($ing['name']);?><?=$ing['unit']?(' ('.$ing['unit'].')'):'';?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                        <td class="unit-cell"><?=htmlspecialchars($it['unit']);?></td>
                        <td><input type="text" name="item_qty[]" class="form-control" value="<?=htmlspecialchars($it['quantity']);?>"></td>
                        <td>
                            <select name="item_location[]" class="form-select">
                                <option value="MAIN" <?=$it['location']==='MAIN'?'selected':'';?>>MAIN</option>
                                <option value="SEC" <?=$it['location']==='SEC'?'selected':'';?>>SEC</option>
                            </select>
                        </td>
                        <td><button type="button" class="btn btn-sm btn-danger" onclick="this.closest('tr').remove()">&times;</button></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            
            <button type="button" class="btn btn-outline-secondary" onclick="addRow()">
                <i class="fas fa-plus me-1"></i><?= __('restocks.add_item', 'Add Item') ?>
            </button>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="restockForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __("common.update", "Update") ?>
        </button>
        <a href="/samanta_crm/restocks/<?=$restock['id'];?>" class="btn btn-secondary">
            <?= __("common.cancel", "Cancel") ?>
        </a>
    </div>
</div>

<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
<script>
const ingredients = <?=json_encode(array_map(function($i){return ['id'=>$i['id'],'name'=>$i['name'],'unit'=>$i['unit']];}, $ingredients));?>;
function addRow(){
	const tbody=document.querySelector('#restock-items tbody');
	const tr=document.createElement('tr');
	tr.innerHTML=`<td><select name="item_ingredient_id[]" class="form-select" onchange="updateUnit(this)">${ingredients.map(i=>`<option value="${i.id}">${i.name}${i.unit?(' ('+i.unit+')'):''}</option>`).join('')}</select></td>
		<td class="unit-cell"></td>
		<td><input type="text" name="item_qty[]" class="form-control" value="0"></td>
		<td><select name="item_location[]" class="form-select"><option value="MAIN">MAIN</option><option value="SEC">SEC</option></select></td>
		<td><button type="button" class="btn btn-sm btn-danger" onclick="this.closest('tr').remove()">&times;</button></td>`;
	tbody.appendChild(tr); updateUnit(tr.querySelector('select'));
}
function updateUnit(sel){ const tr=sel.closest('tr'); const ing=ingredients.find(i=>i.id==sel.value); tr.querySelector('.unit-cell').textContent=ing && ing.unit?ing.unit:''; }
document.querySelectorAll('select[name="item_ingredient_id[]"]').forEach(updateUnit);
</script>
