<?php $title=__('products.map_fields', 'Map Product Import Fields'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-columns"></i> <?= __('products.map_fields', 'Map Fields') ?>
    </h1>
    <div>
        <a href="/samanta_crm/products/import" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<?php if(isset($meta)): ?>
<div class="alert alert-info mb-3">
    <i class="fas fa-info-circle me-1"></i>
    <?= __('products.detected_delimiters', 'Detected Delimiters') ?>: 
    <?= __('products.field', 'Field') ?> <strong><?= $meta['field_delim']==="\t"? 'TAB': htmlspecialchars($meta['field_delim']) ?></strong>, 
    <?= __('products.text', 'Text') ?> <strong><?= htmlspecialchars($meta['text_delim']) ?></strong>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-map me-1"></i><?= __('products.column_mapping', 'Column Mapping') ?></span>
    </div>
    <div class="card-body">
        <p class="text-muted small mb-3"><?= __('products.map_description', 'Match each CSV column to a product field. Leave unmapped to ignore. Flags treat any non-empty value as selected.') ?></p>
        <form method="POST" action="/samanta_crm/products/import/process" id="mapForm">
  <?php if(isset($meta)): ?>
    <input type="hidden" name="_field_delim" value="<?= htmlspecialchars($meta['field_delim']) ?>">
    <input type="hidden" name="_text_delim" value="<?= htmlspecialchars($meta['text_delim']) ?>">
  <?php endif; ?>
  <div class="table-responsive mb-3">
    <table class="table table-sm table-bordered align-middle">
      <thead><tr><th>#</th><th><?= __('products.csv_column', 'CSV Column') ?></th><th><?= __('products.sample_values', 'Sample Values') ?></th><th><?= __('products.map_to', 'Map To') ?></th></tr></thead>
      <tbody>
        <?php foreach($header as $i=>$col): $samples=[]; foreach($sample as $r){ $samples[] = htmlspecialchars($r[$i] ?? ''); } $samples = array_filter(array_unique($samples)); ?>
        <tr>
          <td><?= $i ?></td>
          <td><code><?= htmlspecialchars($col) ?></code></td>
          <td class="small text-muted" style="max-width:220px;">
            <?php foreach(array_slice($samples,0,3) as $sv): ?>
              <div><?= $sv===''?'<span class="text-muted">(empty)</span>':$sv ?></div>
            <?php endforeach; ?>
          </td>
          <td>
            <select name="map[<?= $i ?>]" class="form-select form-select-sm">
              <option value="">-- Ignore --</option>
              <?php foreach($fields as $k=>$label): ?>
                <option value="<?= $k ?>" <?= autoSelect($col,$k)?'selected':'' ?>><?= htmlspecialchars($label) ?></option>
              <?php endforeach; ?>
            </select>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
        </form>
    </div>
    <div class="card-footer py-2">
        <div class="d-flex justify-content-between align-items-center">
            <div class="alert alert-info p-2 mb-0 small">
                <i class="fas fa-key me-1"></i>
                Unique key is <strong>Code</strong>. If mapped and exists, product will be updated.
            </div>
            <div class="d-flex gap-2">
                <button type="submit" form="mapForm" class="btn btn-primary">
                    <i class="fas fa-play me-1"></i>Process Import
                </button>
                <a href="/samanta_crm/products/import" class="btn btn-secondary">Back</a>
            </div>
        </div>
    </div>
</div>
<?php
function autoSelect($csvCol,$fieldKey){
  $c = mb_strtolower(trim($csvCol),'UTF-8');
  $map = [
    'nazwa'=>'name','opis'=>'description','kategoria'=>'category_id','cena'=>'price','za ceną'=>'price_unit','uwagi'=>'notes','produkcja'=>'production_site','kod'=>'code','order'=>'sort_order','faktor'=>'factor','jed. prod.'=>'production_unit','status'=>'status','ogólny'=>'flag:ogolny','kategoria'=>'flag:kategoria','piekarnia'=>'flag:piekarnia','cukiernia'=>'flag:cukiernia','lodziarnia'=>'flag:lodziarnia','magazyn'=>'flag:magazyn','wydawka 1'=>'flag:wydawka1','wydawka 2'=>'flag:wydawka2'
  ];
  return isset($map[$c]) && $map[$c]===$fieldKey;
}
?>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
