<?php $title=__('production_sites.title', 'Production Sites'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-industry"></i> <?= __('production_sites.title', 'Production Sites') ?>
    </h1>
    <div>
        <a href="/samanta_crm/production-sites/create" class="btn btn-primary">
            <i class="fas fa-plus"></i> <?= __('common.add', 'Add') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('production_sites.production_sites', 'Production Sites') ?></span>
    </div>
    <div class="card-body pt-0">
        <div class="table-responsive">
            <table class="table table-sm table-hover align-middle data-table mb-0" id="productionSitesTable">
                <thead class="table-light">
                    <tr>
                        <th><?= __("production_sites.code", "Code") ?></th>
                        <th><?= __("common.name", "Name") ?></th>
                        <th class="d-none d-md-table-cell"><?= __("common.description", "Description") ?></th>
                        <th class="d-none d-xl-table-cell"><?= __("common.order", "Order") ?></th>
                        <th class="d-none d-lg-table-cell"><?= __("common.active", "Active") ?></th>
                        <th class="text-end"><?= __("common.actions", "Actions") ?></th>
                    </tr>
                </thead>
            <tbody>
                <?php foreach($sites as $s): ?>
                <tr>
                    <td><code class="small"><?= htmlspecialchars($s['code']) ?></code></td>
                    <td>
                        <strong class="small"><?= htmlspecialchars($s['name']) ?></strong>
                        <!-- Mobile-only info (phones) -->
                        <div class="d-md-none small text-muted mt-1">
                            <?php if($s['is_active']): ?>
                                <span class="badge bg-success"><?= __("common.yes", "Yes") ?></span>
                            <?php else: ?>
                                <span class="badge bg-secondary"><?= __("common.no", "No") ?></span>
                            <?php endif; ?>
                            <?php if(!empty($s['description'])): ?>
                                <span class="ms-1"><?= htmlspecialchars($s['description']) ?></span>
                            <?php endif; ?>
                        </div>
                    </td>
                    <td class="text-muted small d-none d-md-table-cell"><?= htmlspecialchars($s['description'] ?? '') ?></td>
                    <td class="d-none d-xl-table-cell"><?= (int)$s['sort_order'] ?></td>
                    <td class="d-none d-lg-table-cell">
                        <?php if($s['is_active']): ?>
                            <span class="badge bg-success"><?= __("common.yes", "Yes") ?></span>
                        <?php else: ?>
                            <span class="badge bg-secondary"><?= __("common.no", "No") ?></span>
                        <?php endif; ?>
                    </td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <a class="btn btn-outline-primary" href="/samanta_crm/production-sites/<?= $s['id'] ?>/edit" title="<?= __('common.edit', 'Edit') ?>">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form method="POST" action="/samanta_crm/production-sites/<?= $s['id'] ?>/delete" class="d-inline" onsubmit="return confirm('<?= __('common.confirm_delete', 'Delete?') ?>')">
                                <button class="btn btn-outline-danger" title="<?= __('common.delete', 'Delete') ?>">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer py-2 d-flex justify-content-between align-items-center">
        <span></span>
        <div class="small text-muted">
            <?= __("common.total", "Total") ?>: <?= count($sites) ?> <?= __("common.items", "items") ?>
        </div>
    </div>
</div>
</div>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
