<?php $title=__('orders.orders', 'Orders'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-2 flex-column flex-lg-row flex-md-column">
    <h1 class="h3 mb-3">
        <i class="fas fa-receipt"></i> <?= __('orders.orders', 'Orders') ?>
    </h1>
    <div class="gap-3 flex-lg-row flex-md-column text-center">
        <a href="/samanta_crm/reports/daily" class="btn btn-secondary mb-2"><i class="fas fa-calendar-day me-1"></i> <?= __('reports.daily', 'Daily Report') ?></a>
         
    </div>
    <div class="gap-3 flex-lg-row flex-md-column justify-content-center align-items-center text-center mb-3 mb-lg-0">
        <a href="/samanta_crm/orders/create" class="btn btn-primary mb-2"><i class="fas fa-plus"></i> <?= __('orders.new_order', 'New Order') ?></a>
         <a href="/samanta_crm/orders/panel" class="btn btn-info mb-2"><i class="fas fa-tablet-alt"></i> <?= __('orders.tablet_panel', 'Tablet Panel') ?></a>
        
        <a href="/samanta_crm/orders?export=excel" class="btn btn-secondary mb-2"><i class="fas fa-file-excel"></i> Excel</a>
       
    </div>
</div>

<form class="row g-2 align-items-end data-filters position-sticky sticky-top" method="GET" action="/samanta_crm/orders">
  <div class="card mb-3">
    <div class="card-header py-2 d-flex justify-content-between align-items-center ">
      <span class="small fw-bold"><i class="fas fa-filter me-1"></i><?= __('common.filters', 'Filters') ?></span>
      <button class="btn btn-sm btn-outline-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#filtersWrap">
        <i class="fas fa-chevron-down"></i>
      </button>
    </div>
    <div class="collapse collapsed " id="filtersWrap">
      <div class="card-body py-3">
        <div class="row g-2 align-items-end">
          <div class="col-md-2 col-6">
            <label class="form-label small mb-0 "><?= __('common.from', 'From') ?></label>
            <input type="date" name="date_from" value="<?=htmlspecialchars($filters['date_from'] ?? '', ENT_QUOTES, 'UTF-8')?>" class="form-control form-control-sm" placeholder="<?= __('common.from', 'From') ?>">
          </div>
          <div class="col-md-2 col-6">
            <label class="form-label small mb-0 "><?= __('common.to', 'To') ?></label>
            <input type="date" name="date_to" value="<?=htmlspecialchars($filters['date_to'] ?? '', ENT_QUOTES, 'UTF-8')?>" class="form-control form-control-sm" placeholder="<?= __('common.to', 'To') ?>">
          </div>
          <div class="col-md-3 col-6">
            <label class="form-label small mb-0 "><?= __('common.customer', 'Customer') ?></label>
            <select name="customer_id" class="form-select form-select-sm">
              <option value=""><?= __('common.all', 'All') ?></option>
              <?php foreach($customers as $c): ?>
                <option value="<?=$c['id'];?>" <?=$filters['customer_id']==$c['id']?'selected':'';?>><?=htmlspecialchars($c['name'] ?? '', ENT_QUOTES, 'UTF-8');?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-2 col-6">
            <label class="form-label small mb-0 "><?= __('common.type', 'Type') ?></label>
            <select name="order_type" class="form-select form-select-sm">
              <option value=""><?= __('common.all', 'All') ?></option>
              <?php if(isset($orderTypes)) foreach($orderTypes as $ot): ?>
                <option value="<?= htmlspecialchars($ot, ENT_QUOTES, 'UTF-8') ?>" <?=$filters['order_type']==$ot?'selected':'';?>><?=ucfirst(htmlspecialchars($ot, ENT_QUOTES, 'UTF-8'))?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-2 col-6">
            <label class="form-label small mb-0 "><?= __('common.status', 'Status') ?></label>
            <select name="status" class="form-select form-select-sm">
              <option value=""><?= __('common.all', 'All') ?></option>
              <?php foreach(['pending','processing','completed','cancelled'] as $st): ?>
                <option value="<?=$st?>" <?=$filters['status']==$st?'selected':'';?>><?=ucfirst($st)?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-2 col-6">
            <label class="form-label small mb-0 "><?= __('orders.verified', 'Verified') ?></label>
            <select name="verified" class="form-select form-select-sm">
              <option value=""><?= __('common.all', 'All') ?></option>
              <option value="1" <?=$filters['verified']==='1'?'selected':'';?>><?= __('common.yes', 'Yes') ?></option>
              <option value="0" <?=$filters['verified']==='0'?'selected':'';?>><?= __('common.no', 'No') ?></option>
            </select>
          </div>
          <div class="col-auto">
            <button class="btn btn-outline-secondary btn-sm"><i class="fas fa-filter me-1"></i><?= __('common.filter', 'Filter') ?></button>
          </div>
        </div>
      </div>
    </div>
  </div>
</form>

<div class="card">
  <div class="card-header py-2">
    <span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('orders.orders', 'Orders') ?></span>
  </div>
  <div class="card-body pt-0">
    <div class="table-responsive">
      <table class="table table-sm table-hover align-middle data-table mb-0" id="ordersTable">
        <thead class="table-light">
          <tr>
            <th>ID</th>
            <th><?= __('orders.order_date', 'Order Date') ?></th>
            <th class="d-none d-lg-table-cell"><?= __('orders.delivery_date', 'Delivery Date') ?></th>
            <th class="d-none d-md-table-cell"><?= __("common.type", "Type") ?></th>
            <th><?= __('common.customer', 'Customer') ?></th>
            <th class="d-none d-xl-table-cell"><?= __('orders.assigned', 'Assigned') ?></th>
            <th><?= __("common.status", "Status") ?></th>
            <th class="d-none d-lg-table-cell"><?= __('orders.items', 'Items') ?></th>
            <th class="d-none d-xl-table-cell"><?= __('orders.verified', 'Verified') ?></th>
            <th class="text-end"><?= __('common.actions', 'Actions') ?></th>
          </tr>
        </thead>
        <tbody>
          <?php if(empty($orders)): ?>
            <tr><td colspan="10" class="text-center text-muted py-4"><?= __('orders.no_orders_found', 'No orders found') ?></td></tr>
          <?php else: ?>
            <?php foreach($orders as $o): ?>
              <tr>
                <td><code class="small"><strong><?=$o['id']?></strong></code></td>
                <td class="text-nowrap small">
                  <?=date('d/m/y', strtotime($o['order_date']))?>
                  <br>
                  <span class="text-muted" style="font-size:0.7rem"><?=date('H:i', strtotime($o['order_date']))?></span>
                </td>
                <td class="text-nowrap small d-none d-lg-table-cell"><?=date('d/m/y', strtotime($o['delivery_date']))?></td>
                <td class="d-none d-md-table-cell"><span class="badge bg-<?=htmlspecialchars($o['order_type'] ?? '', ENT_QUOTES, 'UTF-8')?>"><?=htmlspecialchars($o['order_type'] ?? '', ENT_QUOTES, 'UTF-8')?></span></td>
                <td>
                  <strong class="small"><?=htmlspecialchars($o['customer_name'] ?? '', ENT_QUOTES, 'UTF-8')?></strong>
                  <!-- Mobile wrapped info -->
                  <div class="d-md-none small text-muted mt-1">
                    <span class="badge bg-<?=htmlspecialchars($o['order_type'] ?? '', ENT_QUOTES, 'UTF-8')?> me-1"><?=htmlspecialchars($o['order_type'] ?? '', ENT_QUOTES, 'UTF-8')?></span>
                    <span class="badge bg-<?= $o['status']==='completed'?'success':($o['status']==='cancelled'?'danger':'secondary'); ?>"><?=htmlspecialchars($o['status'] ?? '', ENT_QUOTES, 'UTF-8')?></span>
                  </div>
                  <!-- Tablet info (delivery date) -->
                  <div class="d-lg-none small text-muted mt-1">
                    <i class="fas fa-truck me-1"></i><?=date('d/m/y', strtotime($o['delivery_date']))?>
                  </div>
                </td>
                <td class="text-muted small d-none d-xl-table-cell"><?=htmlspecialchars($o['assigned_user_name'] ?? '', ENT_QUOTES, 'UTF-8')?></td>
                <td class="d-none d-md-table-cell"><span class="badge bg-<?= $o['status']==='completed'?'success':($o['status']==='cancelled'?'danger':'secondary'); ?>"><?=htmlspecialchars($o['status'] ?? '', ENT_QUOTES, 'UTF-8')?></span></td>
                <td class="d-none d-lg-table-cell"><?= (int)($o['items_count'] ?? 0) ?></td>
                <td class="text-center d-none d-xl-table-cell"><?= $o['confirmed']?'<i class="fas fa-check text-success"></i>':'<i class="fas fa-times text-muted"></i>' ?></td>
                <td class="text-end">
                  <div class="btn-group btn-group-sm">
                    <a href="/samanta_crm/orders/<?=$o['id']?>" class="btn btn-outline-secondary" title="<?= __('common.show', 'Show') ?>"><i class="fas fa-eye"></i></a>
                    <a href="/samanta_crm/orders/<?=$o['id']?>/edit" class="btn btn-outline-primary d-none d-sm-inline-block" title="<?= __('common.edit', 'Edit') ?>"><i class="fas fa-edit"></i></a>
                    <form method="POST" action="/samanta_crm/orders/<?=$o['id']?>/delete" onsubmit="return confirm('<?= __('orders.confirm_delete', 'Delete order') ?> #<?=$o['id']?>?');" class="d-inline d-none d-sm-inline-block">
                      <button class="btn btn-outline-danger" title="<?= __('common.delete', 'Delete') ?>"><i class="fas fa-trash"></i></button>
                    </form>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
  <?php if(!empty($orders)): ?>
  <div class="card-footer py-2 d-flex justify-content-between align-items-center">
    <span></span>
    <div class="small text-muted">
      <?= __('common.total', 'Total') ?>: <?= count($orders) ?> <?= __('common.items', 'items') ?>
    </div>
  </div>
  <?php endif; ?>
</div>

<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
