<?php $title=__('customers.title', 'Customers'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-users"></i> <?= __('customers.title', 'Customers') ?>
    </h1>
    <div class="btn-group">
        <a href="/samanta_crm/customers/create" class="btn btn-primary">
            <i class="fas fa-plus"></i> <?= __('common.new', 'New') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2 d-flex justify-content-between align-items-center">
        <span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('customers.title', 'Customers') ?></span>
    </div>
    <div class="card-body pt-0">
        <table class="table table-sm table-hover align-middle data-table mb-0">
            <thead>
                <tr>
                    <th><?= __('common.name', 'Name') ?></th>
                    <th><?= __('common.email', 'Email') ?></th>
                    <th><?= __('customers.phone', 'Phone') ?></th>
                    <th><?= __('common.status', 'Status') ?></th>
                    <th class="text-end"><?= __('common.actions', 'Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($customers as $c): ?>
                <tr>
                    <td><strong><?= htmlspecialchars($c['name']) ?></strong></td>
                    <td><?= htmlspecialchars($c['email']) ?></td>
                    <td><?= htmlspecialchars($c['phone']) ?></td>
                    <td>
                        <span class="badge bg-<?= $c['status']==='active'?'success':'secondary' ?>">
                            <?= htmlspecialchars($c['status']) ?>
                        </span>
                    </td>
                    <td class="text-end">
                        <a class="btn btn-sm btn-outline-primary" href="/samanta_crm/customers/<?= $c['id'] ?>/edit">
                            <i class="fas fa-edit"></i> <?= __('common.edit', 'Edit') ?>
                        </a>
                        <form action="/samanta_crm/customers/<?= $c['id'] ?>/delete" method="POST" class="d-inline" onsubmit="return confirm('<?= __('customers.confirm_delete', 'Delete customer?') ?>')">
                            <button class="btn btn-sm btn-outline-danger">
                                <i class="fas fa-trash"></i> <?= __('common.delete', 'Del') ?>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="card-footer py-2 d-flex justify-content-between align-items-center">
        <span></span>
        <div class="small text-muted">
            <?= __('common.total', 'Total') ?>: <?= count($customers) ?> <?= __('common.items', 'items') ?>
        </div>
    </div>
</div>
<?php $content=ob_get_clean(); require_once __DIR__.'/../layout.php'; ?>
