<div class="mb-3">
  <label class="form-label"><?= __('common.name', 'Name') ?> *</label>
  <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($customer['name']??'') ?>" required>
</div>
<div class="row g-3">
  <div class="col-md-4">
    <label class="form-label"><?= __('common.email', 'Email') ?></label>
    <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($customer['email']??'') ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label"><?= __('customers.phone', 'Phone') ?></label>
    <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($customer['phone']??'') ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label"><?= __("common.status", "Status") ?></label>
    <select name="status" class="form-select">
      <?php $st=$customer['status']??'active'; ?>
      <option value="active" <?= $st==='active'?'selected':'' ?>><?= __("common.active", "Active") ?></option>
      <option value="inactive" <?= $st==='inactive'?'selected':'' ?>><?= __("common.inactive", "Inactive") ?></option>
    </select>
  </div>
</div>
<div class="mb-3 mt-3">
  <label class="form-label"><?= __('customers.address', 'Address') ?></label>
  <textarea name="address" class="form-control" rows="2"><?= htmlspecialchars($customer['address']??'') ?></textarea>
</div>
<div class="mb-3">
  <label class="form-label"><?= __('common.notes', 'Notes') ?></label>
  <textarea name="notes" class="form-control" rows="2"><?= htmlspecialchars($customer['notes']??'') ?></textarea>
</div>
<hr>
<?php
$selCatsIds = isset($sel_categories)? array_column($sel_categories,'id'):[];
$selBlockedIds = isset($sel_blocked)? array_column($sel_blocked,'id'):[];
$selAddIds = isset($sel_additional)? array_column($sel_additional,'id'):[];
$selUserIds = isset($sel_users)? array_column($sel_users,'id'):[];
$countCats = isset($relation_counts)?$relation_counts['categories']:count($selCatsIds);
$countBlocked = isset($relation_counts)?$relation_counts['blocked']:count($selBlockedIds);
$countAdd = isset($relation_counts)?$relation_counts['additional']:count($selAddIds);
$countUsers = isset($relation_counts)?$relation_counts['users']:count($selUserIds);
?>
<div class="row g-3">
  <div class="col-md-3">
    <label class="form-label"><?= __('customers.category_access', 'Category Access') ?> <span class="badge bg-secondary" id="catCount"><?= $countCats ?></span></label>
    <div class="border rounded p-2 small bg-light" id="catSummary"><?= __('common.none', 'None') ?></div>
    <button type="button" class="btn btn-sm btn-outline-primary mt-2" data-bs-toggle="modal" data-bs-target="#modalCategories"><i class="fas fa-folder-open me-1"></i><?= __('common.manage', 'Manage') ?></button>
  </div>
  <div class="col-md-3">
    <label class="form-label"><?= __('customers.blocked_products', 'Blocked Products') ?> <span class="badge bg-secondary" id="blkCount"><?= $countBlocked ?></span></label>
    <div class="border rounded p-2 small bg-light" id="blkSummary"><?= __('common.none', 'None') ?></div>
    <button type="button" class="btn btn-sm btn-outline-danger mt-2" data-bs-toggle="modal" data-bs-target="#modalBlocked"><i class="fas fa-ban me-1"></i><?= __('common.manage', 'Manage') ?></button>
  </div>
  <div class="col-md-3">
    <label class="form-label"><?= __('customers.additional_products', 'Additional Products') ?> <span class="badge bg-secondary" id="addCount"><?= $countAdd ?></span></label>
    <div class="border rounded p-2 small bg-light" id="addSummary"><?= __('common.none', 'None') ?></div>
    <button type="button" class="btn btn-sm btn-outline-success mt-2" data-bs-toggle="modal" data-bs-target="#modalAdditional"><i class="fas fa-plus-circle me-1"></i><?= __('common.manage', 'Manage') ?></button>
  </div>
  <div class="col-md-3">
    <label class="form-label"><?= __('customers.assigned_users', 'Assigned Users') ?> <span class="badge bg-secondary" id="usrCount"><?= $countUsers ?></span></label>
    <select name="assigned_users[]" class="visually-hidden" multiple id="hiddenUsersSelect">
      <?php foreach($users as $u): if(in_array($u['id'],$selUserIds)): ?><option value="<?= $u['id'] ?>" selected></option><?php endif; endforeach; ?>
    </select>
    <div class="border rounded p-2 small bg-light" id="usrSummary"><?= __('common.none', 'None') ?></div>
    <button type="button" class="btn btn-sm btn-outline-secondary mt-2" data-bs-toggle="modal" data-bs-target="#modalUsers"><i class="fas fa-users me-1"></i><?= __('common.manage', 'Manage') ?></button>
  </div>
</div>

<!-- Hidden containers for selected IDs -->
<div id="hiddenInputs" class="d-none">
  <!-- Populated by JS with <input type='hidden' name='category_access[]'> etc -->
  <?php foreach($selCatsIds as $id): ?><input type="hidden" name="category_access[]" value="<?= $id ?>" data-rel="cat"><?php endforeach; ?>
  <?php foreach($selBlockedIds as $id): ?><input type="hidden" name="blocked_products[]" value="<?= $id ?>" data-rel="blk"><?php endforeach; ?>
  <?php foreach($selAddIds as $id): ?><input type="hidden" name="additional_products[]" value="<?= $id ?>" data-rel="add"><?php endforeach; ?>
</div>
