<?php $title=__('customers.edit_customer', 'Edit Customer'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-user-edit"></i> <?= __('customers.edit_customer', 'Edit Customer') ?>
    </h1>
    <div>
        <a href="/samanta_crm/customers" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-edit me-1"></i><?= __('customers.customer_details', 'Customer Details') ?></span>
    </div>
    <div class="card-body">
        <form method="POST" action="/samanta_crm/customers/<?= $customer['id'] ?>/update" id="customerForm">
            <?php require __DIR__.'/form_fields.php'; ?>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="customerForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __('common.update', 'Update') ?>
        </button>
        <a href="/samanta_crm/customers" class="btn btn-secondary">
            <?= __('common.cancel', 'Cancel') ?>
        </a>
    </div>
</div>

<?php require __DIR__.'/modals.php'; ?>

<?php $content=ob_get_clean(); require_once __DIR__.'/../layout.php'; ?>
