<?php $title=__('categories.categories', 'Categories'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-layer-group"></i> <?= __('categories.categories', 'Categories') ?>
    </h1>
    <div class="btn-group">
        <a href="/samanta_crm/categories/create" class="btn btn-primary">
            <i class="fas fa-plus"></i> <?= __('common.add', 'Add') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2 d-flex justify-content-between align-items-center">
        <span class="small fw-bold"><i class="fas fa-table me-1"></i><?= __('categories.categories', 'Categories') ?></span>
    </div>
    <div class="card-body pt-0">
        <table class="table table-sm table-hover align-middle data-table mb-0">
            <thead>
                <tr>
                    <th><?= __('common.name', 'Name') ?></th>
                    <th><?= __('common.description', 'Description') ?></th>
                    <th><?= __('common.sort_order', 'Order') ?></th>
                    <th class="text-end"><?= __('common.actions', 'Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($categories as $c): ?>
                <tr>
                    <td><strong><?= htmlspecialchars($c['name']) ?></strong></td>
                    <td class="text-muted small"><?= htmlspecialchars($c['description'] ?? '') ?></td>
                    <td><?= (int)$c['sort_order'] ?></td>
                    <td class="text-end">
                        <a class="btn btn-sm btn-outline-primary" href="/samanta_crm/categories/<?= $c['id'] ?>/edit">
                            <?= __('common.edit', 'Edit') ?>
                        </a>
                        <form method="POST" action="/samanta_crm/categories/<?= $c['id'] ?>/delete" class="d-inline" onsubmit="return confirm('<?= __('categories.confirm_delete', 'Delete?') ?>')">
                            <button class="btn btn-sm btn-outline-danger">
                                <?= __('common.delete', 'Del') ?>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="card-footer py-2 d-flex justify-content-between align-items-center">
        <span></span>
        <div class="small text-muted">
            <?= __('common.total', 'Total') ?>: <?= count($categories) ?> <?= __('common.items', 'items') ?>
        </div>
    </div>
</div>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
