<?php $title=__('categories.edit_category', 'Edit Category'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-layer-group"></i> <?= __('categories.edit_category', 'Edit Category') ?>
    </h1>
    <div>
        <a href="/samanta_crm/categories" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-edit me-1"></i><?= __('categories.category_details', 'Category Details') ?></span>
    </div>
    <div class="card-body">
        <form method="POST" action="/samanta_crm/categories/<?= $category['id'] ?>/update" id="categoryForm">
            <div class="mb-3">
                <label class="form-label"><?= __('common.name', 'Name') ?> *</label>
                <input name="name" value="<?= htmlspecialchars($category['name']) ?>" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.description', 'Description') ?></label>
                <textarea name="description" class="form-control" rows="3"><?= htmlspecialchars($category['description']) ?></textarea>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.sort_order', 'Sort Order') ?></label>
                <input name="sort_order" value="<?= htmlspecialchars($category['sort_order']) ?>" class="form-control" type="number">
            </div>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="categoryForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __('common.update', 'Update') ?>
        </button>
        <a href="/samanta_crm/categories" class="btn btn-secondary">
            <?= __('common.cancel', 'Cancel') ?>
        </a>
    </div>
</div>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
