<?php $title=__('categories.add_category', 'Add Category'); ob_start(); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-layer-group"></i> <?= __('categories.add_category', 'Add Category') ?>
    </h1>
    <div>
        <a href="/samanta_crm/categories" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i><?= __('common.back', 'Back') ?>
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header py-2">
        <span class="small fw-bold"><i class="fas fa-plus me-1"></i><?= __('categories.category_details', 'Category Details') ?></span>
    </div>
    <div class="card-body">
        <form method="POST" action="/samanta_crm/categories" id="categoryForm">
            <div class="mb-3">
                <label class="form-label"><?= __('common.name', 'Name') ?> *</label>
                <input name="name" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.description', 'Description') ?></label>
                <textarea name="description" class="form-control" rows="3"></textarea>
            </div>
            <div class="mb-3">
                <label class="form-label"><?= __('common.sort_order', 'Sort Order') ?></label>
                <input name="sort_order" value="0" class="form-control" type="number">
            </div>
        </form>
    </div>
    <div class="card-footer py-2 d-flex gap-2">
        <button type="submit" form="categoryForm" class="btn btn-primary">
            <i class="fas fa-save me-1"></i><?= __('common.save', 'Save') ?>
        </button>
        <a href="/samanta_crm/categories" class="btn btn-secondary">
            <?= __('common.cancel', 'Cancel') ?>
        </a>
    </div>
</div>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
