<?php
session_start();

// Manually set session data to test dashboard access
$_SESSION['user_id'] = 1;
$_SESSION['user_name'] = 'Test User';
$_SESSION['user_role'] = 'admin';
$_SESSION['user_type_id'] = 1;

echo "<h2>Manual Session Test</h2>";
echo "<p>Session data set manually:</p>";
echo "<ul>";
echo "<li>User ID: " . $_SESSION['user_id'] . "</li>";
echo "<li>User Name: " . $_SESSION['user_name'] . "</li>";
echo "<li>User Role: " . $_SESSION['user_role'] . "</li>";
echo "</ul>";

echo "<h3>Testing Dashboard Access:</h3>";
echo "<p><a href='/samanta_crm/dashboard' target='_blank'>Try Dashboard Now</a></p>";

echo "<h3>Alternative: Test Controller Directly</h3>";
try {
    require_once '../bootstrap/env.php';
    require_once '../bootstrap/db.php';
    
    // Test if we can load the UserController
    require_once '../app/Controllers/UserController.php';
    
    echo "<p style='color: green;'>✅ UserController loaded successfully</p>";
    
    $userController = new UserController();
    echo "<p style='color: green;'>✅ UserController instantiated</p>";
    
    // Try to call dashboard method
    ob_start();
    $userController->dashboard();
    $dashboardOutput = ob_get_clean();
    
    echo "<p style='color: green;'>✅ Dashboard method executed</p>";
    echo "<h4>Dashboard Output:</h4>";
    echo "<div style='border: 1px solid #ccc; padding: 10px; max-height: 300px; overflow: auto;'>";
    echo $dashboardOutput;
    echo "</div>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>
