<?php
session_start();
require_once '../bootstrap/env.php';
require_once '../bootstrap/db.php';
require_once '../app/helpers/translation.php';

// Set default language if not set
if (!isset($_SESSION['language'])) {
    $_SESSION['language'] = 'en';
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Translation Test</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1>Translation System Test</h1>
        
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Test Results</h5>
                
                <p><strong>Function exists:</strong> 
                    <?= function_exists('__') ? '<span class="text-success">✓ Yes</span>' : '<span class="text-danger">✗ No</span>' ?>
                </p>
                
                <p><strong>Current language:</strong> 
                    <?php 
                    try {
                        require_once '../app/Models/Translation.php';
                        echo Translation::getCurrentLanguage();
                    } catch (Exception $e) {
                        echo '<span class="text-danger">Error: ' . $e->getMessage() . '</span>';
                    }
                    ?>
                </p>
                
                <p><strong>Translation test (dashboard.title):</strong> 
                    <?php 
                    try {
                        echo __('dashboard.title', 'Dashboard');
                    } catch (Exception $e) {
                        echo '<span class="text-danger">Error: ' . $e->getMessage() . '</span>';
                    }
                    ?>
                </p>
                
                <p><strong>Translation test (nav.users):</strong> 
                    <?php 
                    try {
                        echo __('nav.users', 'Users');
                    } catch (Exception $e) {
                        echo '<span class="text-danger">Error: ' . $e->getMessage() . '</span>';
                    }
                    ?>
                </p>
                
                <p><strong>Fallback test (non.existent.key):</strong> 
                    <?php 
                    try {
                        echo __('non.existent.key', 'Default Value');
                    } catch (Exception $e) {
                        echo '<span class="text-danger">Error: ' . $e->getMessage() . '</span>';
                    }
                    ?>
                </p>
                
                <p><strong>Auto-create test 1 (orders.tablet_panel):</strong> 
                    <?php 
                    try {
                        echo __('orders.tablet_panel', 'Tablet Panel');
                    } catch (Exception $e) {
                        echo '<span class="text-danger">Error: ' . $e->getMessage() . '</span>';
                    }
                    ?>
                </p>
                
                <p><strong>Auto-create test 2 (test.unique_<?= time() ?>):</strong> 
                    <?php 
                    $uniqueKey = 'test.unique_' . time();
                    try {
                        echo __($uniqueKey, 'Unique Test Value');
                    } catch (Exception $e) {
                        echo '<span class="text-danger">Error: ' . $e->getMessage() . '</span>';
                    }
                    ?>
                </p>
                
                <h6 class="mt-4">Database Verification</h6>
                <?php
                require_once '../app/Models/Translation.php';
                require_once '../app/Models/Language.php';
                
                $translationModel = new Translation();
                $languageModel = new Language();
                
                // Get all languages
                echo '<p><strong>Available Languages:</strong><br>';
                $allLangs = $languageModel->getAll();
                foreach ($allLangs as $l) {
                    echo 'ID: ' . $l['id'] . ' - Code: ' . $l['code'] . ' - Name: ' . $l['name'] . '<br>';
                }
                echo '</p>';
                
                // Check current language
                $currentCode = Translation::getCurrentLanguage();
                echo '<p><strong>Current Language Code:</strong> ' . $currentCode . '</p>';
                
                $lang = $languageModel->findByCode($currentCode);
                
                if ($lang) {
                    echo '<p><strong>Current Language ID:</strong> ' . $lang['id'] . '</p>';
                    
                    $check1 = $translationModel->getByKey('orders.tablet_panel', $lang['id']);
                    echo '<p><strong>orders.tablet_panel in DB:</strong> ';
                    echo $check1 ? '<span class="text-success">✓ ' . htmlspecialchars($check1) . '</span>' : '<span class="text-warning">Not found</span>';
                    echo '</p>';
                    
                    if (isset($uniqueKey)) {
                        $check2 = $translationModel->getByKey($uniqueKey, $lang['id']);
                        echo '<p><strong>' . $uniqueKey . ' in DB:</strong> ';
                        echo $check2 ? '<span class="text-success">✓ ' . htmlspecialchars($check2) . '</span>' : '<span class="text-warning">Not found</span>';
                        echo '</p>';
                    }
                    
                    // Check if it was created in English instead
                    $enLang = $languageModel->findByCode('en');
                    if ($enLang && $enLang['id'] != $lang['id']) {
                        echo '<h6 class="mt-3">English Language Check (ID: ' . $enLang['id'] . '):</h6>';
                        $check1En = $translationModel->getByKey('orders.tablet_panel', $enLang['id']);
                        echo '<p><strong>orders.tablet_panel in EN DB:</strong> ';
                        echo $check1En ? '<span class="text-success">✓ ' . htmlspecialchars($check1En) . '</span>' : '<span class="text-warning">Not found</span>';
                        echo '</p>';
                    }
                } else {
                    echo '<p class="text-danger">Language not found for code: ' . $currentCode . '</p>';
                }
                ?>
                
                <h6 class="mt-4">Configuration</h6>
                <p><strong>AUTO_CREATE_TRANSLATIONS:</strong> 
                    <?= defined('AUTO_CREATE_TRANSLATIONS') ? (AUTO_CREATE_TRANSLATIONS ? '<span class="text-success">✓ Enabled</span>' : '<span class="text-danger">✗ Disabled</span>') : '<span class="text-warning">Not defined</span>' ?>
                </p>
                <p><strong>AUTO_TRANSLATION_LOG:</strong> 
                    <?= defined('AUTO_TRANSLATION_LOG') ? (AUTO_TRANSLATION_LOG ? '<span class="text-success">✓ Enabled</span>' : '<span class="text-danger">✗ Disabled</span>') : '<span class="text-warning">Not defined</span>' ?>
                </p>
            </div>
        </div>
        
        <div class="mt-3">
            <a href="/samanta_crm/dashboard" class="btn btn-primary">Go to Dashboard</a>
        </div>
    </div>
</body>
</html>
