<?php
/**
 * Test Auto-Creation of Translation Strings
 * This script demonstrates how new translation keys are automatically created
 */

session_start();
require_once '../bootstrap/env.php';
require_once '../bootstrap/db.php';
require_once '../app/helpers/translation.php';

// Set default language
if (!isset($_SESSION['language'])) {
    $_SESSION['language'] = 'en';
}

echo "<h2>Auto-Creation Translation Test</h2>";
echo "<p>Auto-creation is: <strong>" . (AUTO_CREATE_TRANSLATIONS ? 'ENABLED' : 'DISABLED') . "</strong></p>";

// Test 1: Use a completely new translation key with default
echo "<h3>Test 1: New key with default value</h3>";
$test1 = __('products.test_feature', 'Test Feature');
echo "Result: <strong>$test1</strong><br>";

// Test 2: Use a new key without default (will format the key)
echo "<h3>Test 2: New key without default (auto-formatted)</h3>";
$test2 = __('orders.advanced_search');
echo "Result: <strong>$test2</strong><br>";

// Test 3: Use a key with category structure
echo "<h3>Test 3: Categorized key</h3>";
$test3 = __('dashboard.widgets.sales_chart', 'Sales Chart Widget');
echo "Result: <strong>$test3</strong><br>";

// Test 4: Use existing key (should not create duplicate)
echo "<h3>Test 4: Existing key (should use existing)</h3>";
$test4 = __('dashboard.title', 'Default Dashboard');
echo "Result: <strong>$test4</strong><br>";

echo "<hr>";
echo "<h3>What happens behind the scenes:</h3>";
echo "<ul>";
echo "<li>✅ New translation keys are automatically added to the database</li>";
echo "<li>✅ Category is auto-detected from key prefix (e.g., 'products.name' → 'products' category)</li>";
echo "<li>✅ Default values are used if provided, otherwise key is formatted</li>";
echo "<li>✅ Existing translations are not overwritten</li>";
echo "<li>✅ Process is logged if AUTO_TRANSLATION_LOG is enabled</li>";
echo "</ul>";

echo "<hr>";
echo "<p><strong>Go check your translation manager to see the new keys!</strong></p>";
echo "<p><a href='/samanta_crm/languages' class='btn btn-primary'>Manage Translations</a></p>";

// Show some example usage patterns
echo "<h3>Usage Examples:</h3>";
echo "<pre><code>";
echo "// In your views, just use new keys with defaults:\n";
echo "echo __('products.bulk_delete', 'Bulk Delete');\n";
echo "echo __('orders.export_pdf', 'Export PDF');\n";
echo "echo __('customers.merge_accounts', 'Merge Accounts');\n\n";

echo "// Keys will be automatically created in database!\n";
echo "// Categories are auto-detected from the first part:\n";
echo "//   'products.bulk_delete' → 'products' category\n";
echo "//   'orders.export_pdf' → 'orders' category\n";
echo "//   'nav.settings' → 'nav' category\n";
echo "</code></pre>";
?>
