<?php
session_start();
require_once 'bootstrap/db.php';
require_once 'app/Models/Language.php';

echo "<h2>Creating Default Languages</h2>";

$languageModel = new Language();

// Check if languages already exist
$existing = $languageModel->getAll();
if (!empty($existing)) {
    echo "<p>Languages already exist:</p>";
    foreach ($existing as $lang) {
        echo "<p>- {$lang['name']} ({$lang['code']})</p>";
    }
    echo "<hr>";
}

// Default languages to create
$defaultLanguages = [
    [
        'code' => 'en',
        'name' => 'English',
        'native_name' => 'English',
        'flag' => '🇺🇸',
        'is_active' => 1,
        'is_default' => 1
    ],
    [
        'code' => 'es',
        'name' => 'Spanish',
        'native_name' => 'Español',
        'flag' => '🇪🇸',
        'is_active' => 1,
        'is_default' => 0
    ],
    [
        'code' => 'fr',
        'name' => 'French',
        'native_name' => 'Français',
        'flag' => '🇫🇷',
        'is_active' => 1,
        'is_default' => 0
    ],
    [
        'code' => 'de',
        'name' => 'German',
        'native_name' => 'Deutsch',
        'flag' => '🇩🇪',
        'is_active' => 1,
        'is_default' => 0
    ],
    [
        'code' => 'pl',
        'name' => 'Polish',
        'native_name' => 'Polski',
        'flag' => '🇵🇱',
        'is_active' => 1,
        'is_default' => 0
    ]
];

echo "<h3>Creating languages...</h3>";

foreach ($defaultLanguages as $langData) {
    // Check if language already exists
    $existing = $languageModel->findByCode($langData['code']);
    if ($existing) {
        echo "<p style='color: orange;'>⚠ {$langData['name']} ({$langData['code']}) already exists</p>";
        continue;
    }
    
    if ($languageModel->create($langData)) {
        echo "<p style='color: green;'>✓ Created {$langData['name']} ({$langData['code']})</p>";
    } else {
        echo "<p style='color: red;'>✗ Failed to create {$langData['name']} ({$langData['code']})</p>";
    }
}

echo "<hr>";
echo "<h3>Final language list:</h3>";
$finalLanguages = $languageModel->getAll();
foreach ($finalLanguages as $lang) {
    $defaultText = $lang['is_default'] ? ' (DEFAULT)' : '';
    $activeText = $lang['is_active'] ? 'Active' : 'Inactive';
    echo "<p>ID: {$lang['id']} - {$lang['name']} ({$lang['code']}) - {$activeText}{$defaultText}</p>";
}

echo "<p style='margin-top: 20px; padding: 15px; background-color: #d4edda; border: 1px solid #c3e6cb; border-radius: 5px;'>";
echo "<strong>Default languages created!</strong> You can now manage languages and translations.";
echo "</p>";
?>
