<?php
require_once 'bootstrap/db.php';

echo "<h2>Users in Database</h2>";

try {
    $stmt = $pdo->query("SELECT id, name, email, role, created_at FROM users ORDER BY id");
    $users = $stmt->fetchAll();
    
    if (empty($users)) {
        echo "<p style='color: red;'>❌ No users found in database!</p>";
        echo "<p>You need to create a user account first.</p>";
        
        // Create a default admin user
        echo "<h3>Creating Default Admin User...</h3>";
        
        $hashedPassword = password_hash('admin123', PASSWORD_DEFAULT);
        $insertStmt = $pdo->prepare("INSERT INTO users (name, email, password, role, is_active, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
        
        if ($insertStmt->execute(['Admin User', 'admin@samanta-crm.com', $hashedPassword, 'admin', 1])) {
            echo "<p style='color: green;'>✅ Default admin user created!</p>";
            echo "<p><strong>Login Credentials:</strong></p>";
            echo "<p>Email: <code>admin@samanta-crm.com</code></p>";
            echo "<p>Password: <code>admin123</code></p>";
        } else {
            echo "<p style='color: red;'>❌ Failed to create admin user</p>";
        }
    } else {
        echo "<p style='color: green;'>✅ Found " . count($users) . " user(s)</p>";
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Created</th></tr>";
        
        foreach ($users as $user) {
            echo "<tr>";
            echo "<td>{$user['id']}</td>";
            echo "<td>" . htmlspecialchars($user['name']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td>{$user['role']}</td>";
            echo "<td>{$user['created_at']}</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        echo "<p><strong>Note:</strong> If you don't know the password, you may need to reset it.</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Database error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p><a href='/samanta_crm/login'>Go to Login Page</a></p>";
?>
