<?php 
$title = __('users.title', 'Users');
ob_start(); 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-users"></i> <?= __('users.management', 'Users Management') ?>
    </h1>
    <a href="/samanta_crm/users/create" class="btn btn-primary">
        <i class="fas fa-plus"></i> <?= __('users.add', 'Add User') ?>
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form class="row g-2 mb-3" method="GET" action="">
            <div class="col-sm-4">
                <input type="text" name="q" value="<?= htmlspecialchars($filter_q ?? '') ?>" class="form-control" placeholder="<?= __('users.search_placeholder', 'Search') ?> <?= __('common.name', 'name') ?> <?= __('common.or', 'or') ?> <?= __('common.email', 'email') ?>...">
            </div>
            <div class="col-sm-3">
                <select name="status" class="form-select">
                    <?php $statuses = ['all'=>__('common.all', 'All').' '.__('users.statuses', 'Statuses'),'active'=>__('common.active', 'Active'),'inactive'=>__('common.inactive', 'Inactive')]; foreach ($statuses as $val=>$label): ?>
                        <option value="<?= $val ?>" <?= ($filter_status??'all')===$val?'selected':'' ?>><?= $label ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-sm-5 d-flex gap-2">
                <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i> <?= __('common.filter', 'Filter') ?></button>
                <a class="btn btn-outline-secondary" href="/samanta_crm/users"><i class="fas fa-times"></i></a>
            </div>
        </form>
        <?php if (empty($users)): ?>
            <div class="text-center py-4">
                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                <h5><?= __('users.no_users', 'No users found') ?></h5>
                <p class="text-muted"><?= __('users.get_started', 'Get started by adding your first user.') ?></p>
                <a href="/samanta_crm/users/create" class="btn btn-primary">
                    <i class="fas fa-plus"></i> <?= __('users.add', 'Add User') ?>
                </a>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover" id="usersTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th><?= __('common.name', 'Name') ?></th>
                            <th><?= __('common.email', 'Email') ?></th>
                            <th><?= __('users.role', 'Role') ?></th>
                            <th><?= __('common.type', 'Type') ?></th>
                            <th><?= __('common.status', 'Status') ?></th>
                            <th><?= __('common.created_at', 'Created') ?></th>
                            <th><?= __('common.actions', 'Actions') ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?= $user['id'] ?></td>
                            <td><?= htmlspecialchars($user['name']) ?></td>
                            <td><?= htmlspecialchars($user['email']) ?></td>
                            <td>
                                <span class="badge bg-<?= $user['role'] === 'admin' ? 'danger' : 'primary' ?>">
                                    <?= ucfirst($user['role']) ?>
                                </span>
                            </td>
                            <td>
                                <?php if ($user['user_type_name']): ?>
                                    <span class="badge" style="background-color: <?= htmlspecialchars($user['user_type_color']) ?>;">
                                        <?= htmlspecialchars($user['user_type_name']) ?>
                                    </span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if (($user['deleted_at'] ?? null) !== null): ?>
                                    <span class="badge bg-secondary"><?= __('users.archived', 'Archived') ?></span>
                                <?php else: ?>
                                    <span class="badge bg-<?= ($user['status'] ?? 'active')==='active' ? 'success' : 'warning' ?>">
                                        <?= ($user['status'] ?? 'active')==='active' ? __('common.active', 'Active') : __('common.inactive', 'Inactive') ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td><?= date('M j, Y g:i A', strtotime($user['created_at'])) ?></td>
                            <td>
                                <div class="btn-group btn-group-sm" role="group">
                                    <a href="/samanta_crm/users/<?= $user['id'] ?>/edit" class="btn btn-outline-primary">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <?php if (($user['deleted_at'] ?? null) === null): ?>
                                        <button type="button" class="btn btn-outline-danger" onclick="deleteUser(<?= $user['id'] ?>, '<?= htmlspecialchars($user['name']) ?>')">
                                            <i class="fas fa-archive"></i>
                                        </button>
                                    <?php else: ?>
                                        <button type="button" class="btn btn-outline-success" onclick="restoreUser(<?= $user['id'] ?>)">
                                            <i class="fas fa-undo"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
        <?php if (!empty($users) && isset($pagination)): $p=$pagination; if($p['pages']>1): ?>
            <nav>
                <ul class="pagination pagination-sm mt-3">
                    <?php for($i=1;$i<=$p['pages'];$i++): $params = http_build_query(['q'=>$filter_q,'status'=>$filter_status,'page'=>$i]); ?>
                        <li class="page-item <?= $i==$p['page']?'active':'' ?>">
                            <a class="page-link" href="?<?= $params ?>"><?= $i ?></a>
                        </li>
                    <?php endfor; ?>
                </ul>
            </nav>
        <?php endif; endif; ?>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?= __('common.confirm_delete', 'Confirm Delete') ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p><?= __('users.confirm_delete_msg', 'Are you sure you want to delete') ?> <strong id="deleteUserName"></strong>?</p>
                <p class="text-muted"><?= __('common.delete_warning', 'This action cannot be undone.') ?></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?= __("common.cancel", "Cancel") ?></button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    <button type="submit" class="btn btn-danger"><?= __("common.delete", "Delete") ?></button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php 
$content = ob_get_clean();
$scripts = '
<script>
function deleteUser(id, name) {
    document.getElementById("deleteUserName").textContent = name;
    document.getElementById("deleteForm").action = "/samanta_crm/users/" + id + "/delete";
    new bootstrap.Modal(document.getElementById("deleteModal")).show();
}
function restoreUser(id){
    const form=document.createElement(\'form\');
    form.method=\'POST\';
    form.action=\'/samanta_crm/users/\'+id+\'/restore\';
    document.body.appendChild(form);form.submit();
}
</script>
';
include '../app/Views/layout.php'; 
?>
