<?php 
$title = __('users.edit', 'Edit User');
ob_start(); 
?>

<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-edit"></i> <?= __('users.edit', 'Edit User') ?>: <?= htmlspecialchars($user['name']) ?>
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="/samanta_crm/users/<?= $user['id'] ?>/update">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label"><?= __('users.full_name', 'Full Name') ?> *</label>
                                <input type="text" class="form-control" id="name" name="name" value="<?= htmlspecialchars($user['name']) ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label"><?= __('users.email_address', 'Email Address') ?> *</label>
                                <input type="email" class="form-control" id="email" name="email" value="<?= htmlspecialchars($user['email']) ?>" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="role" class="form-label"><?= __('users.role', 'Role') ?></label>
                                <select class="form-select" id="role" name="role">
                                    <option value="user" <?= $user['role'] === 'user' ? 'selected' : '' ?>><?= __('users.role_user', 'User') ?></option>
                                    <option value="admin" <?= $user['role'] === 'admin' ? 'selected' : '' ?>><?= __('users.role_admin', 'Administrator') ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="user_type_id" class="form-label"><?= __('users.user_type', 'User Type') ?></label>
                                <select class="form-select" id="user_type_id" name="user_type_id">
                                    <option value=""><?= __('users.select_type', 'Select User Type (Optional)') ?></option>
                                    <?php foreach ($userTypes as $userType): ?>
                                    <option value="<?= $userType['id'] ?>" 
                                            <?= $user['user_type_id'] == $userType['id'] ? 'selected' : '' ?>
                                            style="color: <?= htmlspecialchars($userType['color']) ?>;">
                                        <?= htmlspecialchars($userType['name']) ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="new_password" class="form-label"><?= __('users.new_password', 'New Password') ?></label>
                                <input type="password" class="form-control" id="new_password" name="new_password" minlength="6">
                                <div class="form-text"><?= __('users.leave_blank', 'Leave blank to keep current password') ?></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="confirm_password" class="form-label"><?= __('users.confirm_new_password', 'Confirm New Password') ?></label>
                                <input type="password" class="form-control" id="confirm_password" name="confirm_password">
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-between">
                        <a href="/samanta_crm/users" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> <?= __('common.back', 'Back') ?>
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> <?= __('users.update_btn', 'Update User') ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-body">
                <h6 class="card-title text-muted"><?= __('users.info', 'User Information') ?></h6>
                <p><strong><?= __('users.user_id', 'User ID') ?>:</strong> <?= $user['id'] ?></p>
                <p><strong><?= __('common.created_at', 'Created') ?>:</strong> <?= date('F j, Y g:i A', strtotime($user['created_at'])) ?></p>
                <?php if ($user['updated_at']): ?>
                <p><strong><?= __('common.updated_at', 'Last Updated') ?>:</strong> <?= date('F j, Y g:i A', strtotime($user['updated_at'])) ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php 
$content = ob_get_clean();
$scripts = '
<script>
document.querySelector("form").addEventListener("submit", function(e) {
    const newPassword = document.getElementById("new_password").value;
    const confirmPassword = document.getElementById("confirm_password").value;
    
    if (newPassword && newPassword !== confirmPassword) {
        e.preventDefault();
        alert("' . __('users.new_password_mismatch', 'New passwords do not match!') . '");
        return false;
    }
});
</script>
';
include '../app/Views/layout.php'; 
?>
