<?php $title='Usage History'; ob_start(); ?>
<h1 class="h5 mb-3">Applied Usage History (Aggregated)</h1>
<?php if(isset($_SESSION['success'])): ?><div class="alert alert-success"><?=htmlspecialchars($_SESSION['success']); unset($_SESSION['success']);?></div><?php endif; ?>
<table class="table table-sm table-bordered">
	<thead><tr><th>Date</th><th class="text-end">Items</th><th><?= __("common.actions", "Actions") ?></th></tr></thead>
	<tbody>
	<?php foreach($rows as $r): $rolled = isset($r['rolled_items']) ? ((int)$r['rolled_items']) : 0; $allRolled = ($rolled>0 && $rolled==(int)$r['items']); ?>
		<tr class="<?= $allRolled ? 'table-secondary':''; ?>">
			<td><a href="/samanta_crm/stock/usage-history?date=<?=htmlspecialchars($r['apply_date']);?>"><?=htmlspecialchars($r['apply_date']);?></a></td>
			<td class="text-end"><?= (int)$r['items']; ?></td>
			<td>
				<a href="/samanta_crm/stock/usage-history?date=<?=htmlspecialchars($r['apply_date']);?>" class="btn btn-sm btn-primary">View</a>
				<form method="post" action="/samanta_crm/stock/rollback-daily" style="display:inline" onsubmit="return confirm('Rollback usage for <?=htmlspecialchars($r['apply_date']);?>? This will restore stock.');">
					<input type="hidden" name="rollback_date" value="<?=htmlspecialchars($r['apply_date']);?>">
					<button class="btn btn-sm btn-warning">Rollback</button>
				</form>
			</td>
		</tr>
	<?php endforeach; ?>
	</tbody>
</table>
<a href="/samanta_crm/stock/ingredients" class="btn btn-sm btn-outline-secondary">Back to Stock</a>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
