<?php $title='Ingredient Usage Chart'; ob_start(); ?>
<h1 class="h5 mb-3">Ingredient Usage & Stock</h1>
<form class="row g-2 align-items-end mb-3" method="get">
	<div class="col-auto">
		<label class="form-label form-label-sm mb-1">Start</label>
		<input type="date" name="start_date" class="form-control form-control-sm" value="<?=htmlspecialchars($start_date??'');?>">
	</div>
	<div class="col-auto">
		<label class="form-label form-label-sm mb-1">End</label>
		<input type="date" name="end_date" class="form-control form-control-sm" value="<?=htmlspecialchars($end_date??'');?>">
	</div>
	<div class="col-auto">
		<label class="form-label form-label-sm mb-1">Ingredient</label>
		<select name="ingredient_id" class="form-select form-select-sm">
			<option value="0"><?= __("common.all", "All") ?></option>
			<?php foreach(($ingredients??[]) as $ing): ?>
				<option value="<?=$ing['id'];?>" <?= (int)($ingredient_id??0)==(int)$ing['id']?'selected':''; ?>><?=htmlspecialchars($ing['name']);?></option>
			<?php endforeach; ?>
		</select>
	</div>
	<div class="col-auto">
		<button class="btn btn-sm btn-primary"><?= __("common.update", "Update") ?></button>
	</div>
	<div class="col-auto">
		<a href="/samanta_crm/stock/usage-chart" class="btn btn-sm btn-outline-secondary">Reset</a>
	</div>
</form>
<div class="mb-2 small text-muted">Lines: Applied Usage & Stock. Bars: Restocks. Filter to a single ingredient for detailed lines.</div>
<div class="position-relative" style="height:420px; min-height:420px;">
	<canvas id="usageChart" height="420" style="height:100%; width:100%;"></canvas>
</div>
<div class="mt-3 d-flex gap-2">
	<a href="/samanta_crm/stock/ingredients" class="btn btn-sm btn-outline-secondary">Back</a>
</div>
<?php $content=ob_get_clean(); ob_start(); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
const labels = <?=isset($dates)?json_encode($dates):'[]';?>;
const raw = <?=isset($datasets)?json_encode($datasets):'[]';?>;
function palette(i){ const c=['#0d6efd','#198754','#dc3545','#ff6f00','#20c997','#6f42c1','#fd7e14','#6610f2','#0dcaf0','#1982c4','#8ac926','#ffca3a','#ff595e']; return c[i%c.length]; }
if(labels.length && raw.length){
	const finalDs = [];
	raw.forEach((ds,i)=>{
		const baseColor = palette(i);
		const isStock = ds.series==='stock';
		const isRestock = ds.series==='restock';
		finalDs.push({
			type: ds.type || (isRestock? 'bar':'line'),
			label: ds.label,
			data: ds.data,
			borderColor: baseColor,
			backgroundColor: isRestock? baseColor+'77' : baseColor+'33',
			fill:false,
			tension: isRestock? 0 : 0.15,
			borderDash: isStock? [6,4]:[],
			pointRadius: isRestock? 0:1.5,
			spanGaps:true,
			yAxisID: 'y',
			order: isRestock? 0:1
		});
	});
		const ctx=document.getElementById('usageChart').getContext('2d');
		new Chart(ctx,{
			type:'line',
			data:{ labels:labels, datasets:finalDs },
			options:{
				responsive:true,
				maintainAspectRatio:false,
				aspectRatio: labels.length>0? Math.min(3, Math.max(1.4, ctx.canvas.parentElement.clientWidth/420)) : 2,
				interaction:{mode:'index', intersect:false},
				resizeDelay:50,
				plugins:{ legend:{ position:'bottom'} },
				scales:{ y:{ beginAtZero:true } }
			}
		});
}
	// Hard guard to prevent runaway height if Chart.js miscalculates
	const cEl=document.getElementById('usageChart'); if(cEl && cEl.style.height && parseInt(cEl.style.height)>1200){ cEl.style.height='420px'; }
</script>
<?php $scripts=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
