<?php $title='Ingredient Stock'; ob_start(); ?>
<h1 class="h4 mb-3">Ingredient Stock</h1>
<div class="mb-2">
	<a href="/samanta_crm/stock/ingredients?mode=ledger" class="btn btn-sm btn-outline-secondary">Ledger View</a>
	<div class="btn-group ms-2">
		<a href="/samanta_crm/stock/ingredients?export=csv" class="btn btn-sm btn-outline-success">CSV</a>
		<a href="/samanta_crm/stock/ingredients?export=json" class="btn btn-sm btn-outline-success">JSON</a>
		<a href="/samanta_crm/stock/ingredients?export=xls" class="btn btn-sm btn-outline-success">Excel</a>
		<a href="/samanta_crm/stock/ingredients?print=1" target="_blank" class="btn btn-sm btn-outline-dark">Print</a>
	</div>
    <div class="d-inline-block ms-2">
    	<button id="toggleCollapse" type="button" class="btn btn-sm btn-outline-primary">Collapse Rollback</button>
    	<div class="form-check form-check-inline ms-2 align-middle">
    		<input class="form-check-input" type="checkbox" id="hideZeroRollback">
    		<label class="form-check-label small" for="hideZeroRollback">Hide zero rollback</label>
    	</div>
    </div>
</div>
<div class="card mb-3">
	<div class="card-header py-2 d-flex justify-content-between align-items-center">
		<span class="small fw-bold"><i class="fas fa-plus-circle me-1"></i>Adjust / Add Stock</span>
		<button class="btn btn-sm btn-outline-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#adjustFormWrap">Toggle</button>
	</div>
	<div class="collapse show" id="adjustFormWrap">
		<div class="card-body py-3">
			<form class="row g-2 align-items-end" method="post" action="/samanta_crm/storage/adjust">
				<div class="col-12 col-md-4">
					<label class="form-label small mb-1">Ingredient</label>
					<select name="ingredient_id" class="form-select form-select-sm" required>
						<option value="">Choose...</option>
						<?php foreach($stock as $row): ?>
							<option value="<?=$row['id']?>"><?=htmlspecialchars($row['name'])?> (<?=htmlspecialchars($row['unit'])?>)</option>
						<?php endforeach; ?>
					</select>
				</div>
				<div class="col-6 col-md-2">
					<label class="form-label small mb-1">Quantity (+/-)</label>
					<input type="text" name="quantity" class="form-control form-control-sm" placeholder="e.g. 5" required>
				</div>
				<div class="col-6 col-md-2">
					<label class="form-label small mb-1">Location</label>
					<select name="location" class="form-select form-select-sm">
						<option value="MAIN">MAIN</option>
						<option value="ROLLBACK">ROLLBACK</option>
					</select>
				</div>
				<div class="col-12 col-md-3">
						<label class="form-label small mb-1">Note</label>
						<input type="text" name="note" class="form-control form-control-sm" placeholder="Optional note">
				</div>
				<div class="col-12 col-md-1 d-grid">
					<input type="hidden" name="reason" value="manual_adjust">
					<button class="btn btn-sm btn-primary"><i class="fas fa-save"></i></button>
				</div>
			</form>
			<div class="small text-muted mt-2">Enter a positive number to add stock or a negative number to subtract.</div>
		</div>
	</div>
</div>
<?php if(isset($_SESSION['success'])): ?><div class="alert alert-success"><?=htmlspecialchars($_SESSION['success']); unset($_SESSION['success']);?></div><?php endif; ?>
<form method="post" action="/samanta_crm/stock/apply-daily" class="row g-2 mb-3">
	<div class="col-auto"><input type="date" name="apply_date" value="<?=date('Y-m-d');?>" class="form-control form-control-sm"></div>
	<div class="col-auto"><button class="btn btn-sm btn-primary">Apply Daily Usage</button></div>
</form>
<table class="table table-sm table-striped">
	<thead><tr><th>Ingredient</th><th>Location</th><th class="text-end">Qty</th><th>Unit</th><th><?= __("common.actions", "Actions") ?></th></tr></thead>
	<tbody>
	<?php foreach($stock as $row): ?>
		<?php $mainQty = isset($row['main_stock']) ? (int)round($row['main_stock']) : (int)round($row['stock']); $rollbackQty = (int)round($row['rollback_stock'] ?? 0); ?>
		<tr class="main-row" data-ing="<?=$row['id']?>">
			<td><?= htmlspecialchars($row['name']); ?></td>
			<td><span class="badge bg-primary">MAIN</span></td>
			<td class="text-end"><?=$mainQty?></td>
			<td><?= htmlspecialchars($row['unit']); ?></td>
			<td>
				<a class="btn btn-sm btn-outline-primary" href="/samanta_crm/ingredients/<?=$row['id'];?>/edit"><?= __("common.edit", "Edit") ?></a>
			</td>
		</tr>
		<tr class="rollback-row <?= $rollbackQty===0? 'zero-rollback':''; ?>" data-ing="<?=$row['id']?>">
			<td><?= htmlspecialchars($row['name']); ?></td>
			<td><span class="badge bg-warning text-dark">ROLLBACK</span></td>
			<td class="text-end"><?=$rollbackQty?></td>
			<td><?= htmlspecialchars($row['unit']); ?></td>
			<td>
				<form method="post" action="/samanta_crm/storage/merge-rollback" class="d-inline">
					<input type="hidden" name="ingredient_id" value="<?=$row['id'];?>">
					<button class="btn btn-outline-secondary btn-sm" <?=$rollbackQty===0?'disabled':'';?>>Merge Rollback</button>
				</form>
			</td>
		</tr>
	<?php endforeach; ?>
	</tbody>
</table>
<script>
(function(){
	const btn=document.getElementById('toggleCollapse');
	const hideZeroCb=document.getElementById('hideZeroRollback');
	let collapsed=false;
	function apply(){
		document.querySelectorAll('.rollback-row').forEach(tr=>{
			const isZero=tr.classList.contains('zero-rollback');
			if(collapsed){
				tr.style.display = 'none';
			} else {
				tr.style.display = (hideZeroCb.checked && isZero)?'none':'';
			}
		});
	}
	btn.addEventListener('click',()=>{ collapsed=!collapsed; btn.textContent = collapsed? 'Expand Rollback':'Collapse Rollback'; apply(); });
	hideZeroCb.addEventListener('change',apply);
})();
</script>
<a href="/samanta_crm/stock/usage-history" class="btn btn-sm btn-outline-primary">Usage History</a>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
