<?php $title='Daily Ingredient Usage'; ob_start(); ?>
<h1 class="h5 mb-3">Daily Ingredient Usage (<?=htmlspecialchars($day);?>)</h1>
<div class="d-flex flex-wrap align-items-end gap-2 mb-3">
  <form method="get" class="row g-2 align-items-end">
    <div class="col-auto">
      <input type="date" name="date" value="<?=htmlspecialchars($day);?>" class="form-control form-control-sm">
    </div>
    <div class="col-auto">
      <button class="btn btn-sm btn-primary">Change Date</button>
    </div>
  </form>
  <a href="/samanta_crm/stock/ingredients" class="btn btn-sm btn-outline-secondary">Back</a>
  <form method="post" action="/samanta_crm/stock/apply-usage-all" onsubmit="return confirm('Apply all usage for this date?');">
    <input type="hidden" name="apply_date" value="<?=htmlspecialchars($day);?>">
    <button class="btn btn-sm btn-success">Apply All</button>
  </form>
</div>
<?php if(isset($_SESSION['success'])): ?><div class="alert alert-success py-1 small mb-2"><?=htmlspecialchars($_SESSION['success']); unset($_SESSION['success']);?></div><?php endif; ?>
<?php if(isset($_SESSION['error'])): ?><div class="alert alert-danger py-1 small mb-2"><?=htmlspecialchars($_SESSION['error']); unset($_SESSION['error']);?></div><?php endif; ?>
<table class="table table-sm table-striped align-middle">
  <thead><tr><th>Ingredient</th><th class="text-end">Needed</th><th class="text-end">Applied</th><th class="text-end">To Apply</th><th>Unit</th><th class="text-end">Stock</th><th class="text-end">Remaining After</th><th><?= __("common.status", "Status") ?></th><th style="width:80px">Apply</th></tr></thead>
  <tbody>
  <?php foreach($usage as $u): $rem=$u['remaining_after']; $applied=$u['applied']??0; $toApply=max(0,$u['needed']-$applied); ?>
    <tr class="<?=($rem<0?'table-danger':($rem<($u['needed']*0.2)?'table-warning':''))?>">
      <td><?=htmlspecialchars($u['name']);?></td>
  <td class="text-end"><?= (int)round($u['needed']); ?> <?= htmlspecialchars($u['unit']); ?></td>
  <td class="text-end"><?= (int)round($applied); ?> <?= htmlspecialchars($u['unit']); ?></td>
  <td class="text-end fw-semibold <?= $toApply>0?'text-danger':''; ?>"><?= (int)round($toApply); ?> <?= htmlspecialchars($u['unit']); ?></td>
      <td><?=htmlspecialchars($u['unit']);?></td>
  <td class="text-end"><?= (int)round($u['stock']); ?> <?= htmlspecialchars($u['unit']); ?></td>
  <td class="text-end"><?= (int)round($rem); ?> <?= htmlspecialchars($u['unit']); ?></td>
      <td>
        <?php if($rem<0): ?>
          <span class="badge bg-danger">Shortage</span>
        <?php elseif($rem<($u['needed']*0.2)): ?>
          <span class="badge bg-warning text-dark">Low</span>
        <?php else: ?>
          <span class="badge bg-success">OK</span>
        <?php endif; ?>
      </td>
      <td>
        <form method="post" action="/samanta_crm/stock/apply-usage-single" class="d-flex gap-1 align-items-center">
          <input type="hidden" name="ingredient_id" value="<?=$u['ingredient_id'];?>">
          <input type="hidden" name="apply_date" value="<?=htmlspecialchars($day);?>">
          <input type="hidden" name="desired_qty" value="<?= (int)round($u['needed']); ?>">
          <button class="btn btn-sm btn-outline-primary" title="Apply usage" <?= $toApply<=0? 'disabled':''; ?>>Go</button>
        </form>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
<?php if(!$usage): ?><div class="alert alert-info">No orders found for this date.</div><?php endif; ?>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>