<?php $title=__('restocks.title', 'Restock').' #'.$restock['id']; ob_start(); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
	<h1 class="h5 mb-0"><?= __('restocks.title', 'Restock') ?> #<?=$restock['id'];?> <small class="text-muted">(<?=htmlspecialchars($restock['restock_date']);?>)</small></h1>
	<div>
		<a href="/samanta_crm/restocks/<?=$restock['id'];?>/edit" class="btn btn-sm btn-outline-primary"><?= __("common.edit", "Edit") ?></a>
		<a href="/samanta_crm/restocks" class="btn btn-sm btn-outline-secondary"><?= __('common.back', 'Back') ?></a>
	</div>
 </div>
 <dl class="row small">
	 <dt class="col-sm-2"><?= __('restocks.supplier', 'Supplier') ?></dt><dd class="col-sm-10"><?=htmlspecialchars($restock['supplier']??'');?></dd>
	 <dt class="col-sm-2"><?= __('common.notes', 'Notes') ?></dt><dd class="col-sm-10"><?=htmlspecialchars($restock['notes']??'');?></dd>
 </dl>
 <table class="table table-sm table-bordered">
	 <thead><tr><th>#</th><th><?= __('ingredients.title', 'Ingredient') ?></th><th class="text-end"><?= __('common.quantity', 'Qty') ?></th><th><?= __('units.title', 'Unit') ?></th><th><?= __('common.location', 'Location') ?></th></tr></thead>
	 <tbody>
	 <?php $tot=0; foreach($items as $i=>$it): $tot += $it['quantity']; ?>
		 <tr>
			 <td><?=$i+1;?></td>
			 <td><?=htmlspecialchars($it['name']);?></td>
			 <td class="text-end"><?= (int)round($it['quantity']); ?></td>
			 <td><?=htmlspecialchars($it['unit']);?></td>
			 <td><?=htmlspecialchars($it['location']);?></td>
		 </tr>
	 <?php endforeach; ?>
	 </tbody>
	 <tfoot><tr><th colspan="2"><?= __('common.total', 'Total') ?></th><th class="text-end"><?= (int)round($tot); ?></th><th colspan="2"></th></tr></tfoot>
 </table>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
