<?php $title=__('restocks.edit', 'Edit Restock #').$restock['id']; ob_start(); ?>
<h1 class="h5 mb-3"><?= __('restocks.edit', 'Edit Restock') ?> #<?=$restock['id'];?></h1>
<form method="post" action="/samanta_crm/restocks/<?=$restock['id'];?>/update">
	<div class="row mb-3 g-2">
		<div class="col-md-2"><label class="form-label"><?= __('common.date', 'Date') ?></label><input type="date" name="restock_date" value="<?=htmlspecialchars($restock['restock_date']);?>" class="form-control form-control-sm"></div>
		<div class="col-md-3"><label class="form-label"><?= __('restocks.supplier', 'Supplier') ?></label><input type="text" name="supplier" value="<?=htmlspecialchars($restock['supplier']??'');?>" class="form-control form-control-sm"></div>
		<div class="col-md-7"><label class="form-label"><?= __('common.notes', 'Notes') ?></label><input type="text" name="notes" value="<?=htmlspecialchars($restock['notes']??'');?>" class="form-control form-control-sm"></div>
	</div>
	<table class="table table-sm" id="restock-items">
		<thead><tr><th><?= __('ingredients.title', 'Ingredient') ?></th><th style="width:100px"><?= __('units.title', 'Unit') ?></th><th style="width:140px"><?= __('common.quantity', 'Qty') ?></th><th style="width:140px"><?= __('common.location', 'Location') ?></th><th style="width:40px"></th></tr></thead>
		<tbody>
		<?php foreach($items as $it): ?>
			<tr>
				<td><select name="item_ingredient_id[]" class="form-select form-select-sm" onchange="updateUnit(this)">
					<?php foreach($ingredients as $ing): ?>
						<option value="<?=$ing['id'];?>" <?=$ing['id']==$it['ingredient_id']?'selected':'';?>><?=htmlspecialchars($ing['name']);?><?=$ing['unit']?(' ('.$ing['unit'].')'):'';?></option>
					<?php endforeach; ?>
				</select></td>
				<td class="unit-cell"><?=htmlspecialchars($it['unit']);?></td>
				<td><input type="text" name="item_qty[]" class="form-control form-control-sm" value="<?=htmlspecialchars($it['quantity']);?>"></td>
				<td><select name="item_location[]" class="form-select form-select-sm">
						<option value="MAIN" <?=$it['location']==='MAIN'?'selected':'';?>>MAIN</option>
						<option value="SEC" <?=$it['location']==='SEC'?'selected':'';?>>SEC</option>
				</select></td>
				<td><button type="button" class="btn btn-sm btn-danger" onclick="this.closest('tr').remove()">&times;</button></td>
			</tr>
		<?php endforeach; ?>
		</tbody>
	</table>
	<button type="button" class="btn btn-sm btn-outline-secondary" onclick="addRow()"><?= __('restocks.add_item', 'Add Item') ?></button>
	<button class="btn btn-sm btn-primary"><?= __("common.update", "Update") ?></button>
	<a href="/samanta_crm/restocks/<?=$restock['id'];?>" class="btn btn-sm btn-outline-secondary"><?= __("common.cancel", "Cancel") ?></a>
</form>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
<script>
const ingredients = <?=json_encode(array_map(function($i){return ['id'=>$i['id'],'name'=>$i['name'],'unit'=>$i['unit']];}, $ingredients));?>;
function addRow(){
	const tbody=document.querySelector('#restock-items tbody');
	const tr=document.createElement('tr');
	tr.innerHTML=`<td><select name="item_ingredient_id[]" class="form-select form-select-sm" onchange="updateUnit(this)">${ingredients.map(i=>`<option value="${i.id}">${i.name}${i.unit?(' ('+i.unit+')'):''}</option>`).join('')}</select></td>
		<td class="unit-cell"></td>
		<td><input type="text" name="item_qty[]" class="form-control form-control-sm" value="0"></td>
		<td><select name="item_location[]" class="form-select form-select-sm"><option value="MAIN">MAIN</option><option value="SEC">SEC</option></select></td>
		<td><button type="button" class="btn btn-sm btn-danger" onclick="this.closest('tr').remove()">&times;</button></td>`;
	tbody.appendChild(tr); updateUnit(tr.querySelector('select'));
}
function updateUnit(sel){ const tr=sel.closest('tr'); const ing=ingredients.find(i=>i.id==sel.value); tr.querySelector('.unit-cell').textContent=ing && ing.unit?ing.unit:''; }
document.querySelectorAll('select[name="item_ingredient_id[]"]').forEach(updateUnit);
</script>
