<?php $title='Daily Reports'; ob_start(); ?>
<h3 class="mb-3"><i class="fas fa-chart-bar me-2"></i>Daily Reports</h3>
<form method="GET" class="row g-2 align-items-end mb-4">
  <div class="col-auto">
    <label class="form-label mb-0 small">Date</label>
    <input type="date" name="date" value="<?= htmlspecialchars($date) ?>" class="form-control form-control-sm">
  </div>
  <div class="col-auto">
    <button class="btn btn-sm btn-primary"><i class="fas fa-sync"></i> Load</button>
  </div>
  <div class="col-auto ms-auto">
    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="window.print()"><i class="fas fa-print"></i> Print</button>
  <a href="?date=<?= urlencode($date) ?>&export=csv" class="btn btn-sm btn-outline-success"><i class="fas fa-file-csv"></i> CSV</a>
  <a href="?date=<?= urlencode($date) ?>&export=pdf" class="btn btn-sm btn-outline-danger"><i class="fas fa-file-pdf"></i> PDF</a>
  <a href="?date=<?= urlencode($date) ?>&export=excel" class="btn btn-sm btn-outline-success"><i class="fas fa-file-excel"></i> Excel</a>
  </div>
</form>
<?php if(empty($reports)): ?>
  <div class="alert alert-info">No report data for selected date.</div>
<?php endif; ?>
<?php foreach($reports as $rep): $flag=$rep['flag']; ?>
  <div class="mb-5">
    <h5 class="mb-2"><span class="badge bg-secondary me-2"><?= htmlspecialchars($flag['code']) ?></span><?= htmlspecialchars($flag['label']) ?> <small class="text-muted">(<?= htmlspecialchars($flag['view_type']) ?>)</small></h5>
    <?php if($rep['view_type']==='category_summary'): ?>
      <?php
        // group rows by category and split across 2 column tables
        $byCat=[]; foreach($rep['rows'] as $r){ $cat=$r['category_name'] ?: 'Uncategorized'; $byCat[$cat][]=$r; }
        if(!empty($byCat)) { ksort($byCat, SORT_NATURAL | SORT_FLAG_CASE); }
        $categories = array_keys($byCat);
        $totalCats = count($categories);
        $half = (int)ceil($totalCats/2);
        $leftCats = array_slice($categories,0,$half);
        $rightCats = array_slice($categories,$half);
      ?>
      <div class="row g-3">
        <div class="col-md-6">
          <div class="table-responsive">
            <table class="table table-sm table-bordered align-middle mb-0">
              <thead class="table-light"><tr><th style="width:55%"><?= __("common.name", "Name") ?></th><th style="width:10%" class="text-end">Qty</th><th style="width:10%">Unit</th></tr></thead>
              <tbody>
              <?php if(!$leftCats): ?>
                <tr><td colspan="3" class="text-muted text-center">No data</td></tr>
              <?php else: ?>
                <?php foreach($leftCats as $catName): $rows=$byCat[$catName]; ?>
                  <tr class="table-secondary"><td colspan="3" class="fw-bold"><?= htmlspecialchars($catName) ?></td></tr>
                  <?php foreach($rows as $row): ?>
                  <tr>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td class="text-end"><?= $row['qty']+0 ?></td>
                    <td><?= htmlspecialchars($row['production_unit'] ?? '') ?></td>
                  </tr>
                  <?php endforeach; ?>
                <?php endforeach; ?>
              <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
        <div class="col-md-6">
          <div class="table-responsive">
            <table class="table table-sm table-bordered align-middle mb-0">
              <thead class="table-light"><tr><th style="width:55%"><?= __("common.name", "Name") ?></th><th style="width:10%" class="text-end">Qty</th><th style="width:10%">Unit</th></tr></thead>
              <tbody>
              <?php if(!$rightCats): ?>
                <tr><td colspan="3" class="text-muted text-center">&nbsp;</td></tr>
              <?php else: ?>
                <?php foreach($rightCats as $catName): $rows=$byCat[$catName]; ?>
                  <tr class="table-secondary"><td colspan="3" class="fw-bold"><?= htmlspecialchars($catName) ?></td></tr>
                  <?php foreach($rows as $row): ?>
                  <tr>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td class="text-end"><?= $row['qty']+0 ?></td>
                    <td><?= htmlspecialchars($row['production_unit'] ?? '') ?></td>
                  </tr>
                  <?php endforeach; ?>
                <?php endforeach; ?>
              <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    <?php elseif($rep['view_type']==='category_with_customers'): ?>
      <?php $customers=$rep['customers']; $rows=$rep['rows'];
        // Build column headers with short names (first 3 letters unless contains multibyte) - here simple substr
        $custShort=[]; foreach($customers as $c){ $custShort[$c['id']] = mb_substr($c['name'],0,3); }
        // group by category
        $byCat=[]; foreach($rows as $row){ $cat=$row['category_name'] ?: 'Uncategorized'; $byCat[$cat][]=$row; }
      ?>
      <div class="table-responsive">
        <table class="table table-sm table-bordered align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th style="min-width:240px"><?= __("common.name", "Name") ?></th>
              <?php foreach($customers as $c): ?>
                <th class="text-end" title="<?= htmlspecialchars($c['name']) ?>"><?= htmlspecialchars($custShort[$c['id']]) ?></th>
              <?php endforeach; ?>
              <th class="text-end">Total</th>
              <th class="text-end">Unit</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($byCat as $catName=>$prows): ?>
              <tr class="table-secondary"><td colspan="<?= count($customers)+2 ?>" class="fw-bold"><?= htmlspecialchars($catName) ?></td></tr>
              <?php foreach($prows as $prow): ?>
                <tr>
                  <td><?= htmlspecialchars($prow['name']) ?></td>
                  <?php foreach($customers as $c): $val=$prow['customers'][$c['id']] ?? ''; ?>
                    <td class="text-end"><?= $val!==''? ($val+0):'' ?></td>
                  <?php endforeach; ?>
                  <td class="text-end fw-bold"><?= $prow['total']+0 ?></td>
                  <td class="text-end"><?= htmlspecialchars($prow['production_unit'] ?? '') ?></td>
                </tr>
              <?php endforeach; ?>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
<?php endforeach; ?>
<?php if(!empty($additionalProducts)): ?>
  <div class="mb-5">
    <h5 class="mb-2 text-success"><i class="fas fa-plus-circle me-1"></i>Additional Products (Ordered)</h5>
    <div class="table-responsive">
      <table class="table table-sm table-bordered align-middle">
        <thead class="table-light"><tr><th style="min-width:220px">Product</th><th>Customers (qty)</th><th class="text-end">Total</th></tr></thead>
        <tbody>
          <?php foreach($additionalProducts as $ap): ?>
            <tr>
              <td><?= htmlspecialchars($ap['product_name']) ?></td>
              <td>
                <?php $list=[]; foreach($ap['customers'] as $cid=>$cd){ $list[] = htmlspecialchars($cd['name']).' <span class=\'badge bg-secondary\'>'.($cd['qty']+0).'</span>'; } echo implode(' ', $list); ?>
              </td>
              <td class="text-end fw-bold"><?= $ap['total']+0 ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
<?php endif; ?>
<?php if(!empty($blockedProducts)): ?>
  <div class="mb-5">
    <h5 class="mb-2 text-danger"><i class="fas fa-ban me-1"></i>Blocked Products (Ordered - Review)</h5>
    <div class="table-responsive">
      <table class="table table-sm table-bordered align-middle">
        <thead class="table-dark"><tr><th style="min-width:220px">Product</th><th>Customers (qty)</th><th class="text-end">Total</th></tr></thead>
        <tbody>
          <?php foreach($blockedProducts as $bp): ?>
            <tr class="table-warning">
              <td><?= htmlspecialchars($bp['product_name']) ?></td>
              <td>
                <?php $list=[]; foreach($bp['customers'] as $cid=>$cd){ $list[] = htmlspecialchars($cd['name']).' <span class=\'badge bg-danger\'>'.($cd['qty']+0).'</span>'; } echo implode(' ', $list); ?>
              </td>
              <td class="text-end fw-bold"><?= $bp['total']+0 ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
<?php endif; ?>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
