<?php $title=__('report_flags.edit', 'Edit Report Flag'); ob_start(); ?>
<h3><?= __('report_flags.edit', 'Edit Report Flag') ?></h3>
<form method="POST" action="/samanta_crm/report-flags/<?= $flag['id'] ?>/update">
  <div class="mb-2"><label class="form-label"><?= __('report_flags.code', 'Code') ?> *</label><input name="code" value="<?= htmlspecialchars($flag['code']) ?>" class="form-control form-control-sm" required></div>
  <div class="mb-2"><label class="form-label"><?= __('report_flags.label', 'Label') ?> *</label><input name="label" value="<?= htmlspecialchars($flag['label']) ?>" class="form-control form-control-sm" required></div>
  <div class="mb-2"><label class="form-label"><?= __('common.description', 'Description') ?></label><textarea name="description" class="form-control form-control-sm" rows="2"><?= htmlspecialchars($flag['description'] ?? '') ?></textarea></div>
  <div class="mb-2"><label class="form-label"><?= __('report_flags.view_type', 'View Type') ?></label>
    <?php $vt=$flag['view_type'] ?? 'category_summary'; ?>
    <select name="view_type" class="form-select form-select-sm">
      <option value="category_summary" <?= $vt==='category_summary'?'selected':'' ?>><?= __('report_flags.view_type_summary', 'Category Summary Table') ?></option>
      <option value="category_with_customers" <?= $vt==='category_with_customers'?'selected':'' ?>><?= __('report_flags.view_type_customers', 'Category Table + Customers Column Summary') ?></option>
    </select>
  </div>
  <?php if(isset($products)): ?>
  <div class="row mb-3 g-3">
    <div class="col-md-6">
      <label class="form-label"><?= __('report_flags.include_override', 'Include Only These Products (override)') ?></label>
      <select name="override_include[]" class="form-select form-select-sm" multiple size="8">
        <?php foreach($products as $p): ?>
          <option value="<?= $p['id'] ?>" <?= in_array($p['id'],$overrideInclude??[])?'selected':'' ?>><?= htmlspecialchars($p['name']) ?></option>
        <?php endforeach; ?>
      </select>
      <div class="form-text"><?= __('report_flags.include_override_help', 'If any selected, report will show only these (after customer/day filtering) and exclude all others unless also explicitly excluded.') ?></div>
    </div>
    <div class="col-md-6">
      <label class="form-label"><?= __('report_flags.exclude_override', 'Explicitly Exclude These Products') ?></label>
      <select name="override_exclude[]" class="form-select form-select-sm" multiple size="8">
        <?php foreach($products as $p): ?>
          <option value="<?= $p['id'] ?>" <?= in_array($p['id'],$overrideExclude??[])?'selected':'' ?>><?= htmlspecialchars($p['name']) ?></option>
        <?php endforeach; ?>
      </select>
      <div class="form-text"><?= __('report_flags.exclude_override_help', 'Excluded items won\'t appear even if flagged in product settings.') ?></div>
    </div>
  </div>
  <?php endif; ?>
  <div class="form-check form-check-inline mb-2">
    <input class="form-check-input" type="checkbox" id="rf_show_additional" name="show_additional" <?= !empty($flag['show_additional'])?'checked':'' ?>>
    <label class="form-check-label" for="rf_show_additional"><?= __('report_flags.show_additional', 'Show Additional Products') ?></label>
  </div>
  <div class="form-check form-check-inline mb-2">
    <input class="form-check-input" type="checkbox" id="rf_show_blocked" name="show_blocked" <?= !empty($flag['show_blocked'])?'checked':'' ?>>
    <label class="form-check-label" for="rf_show_blocked"><?= __('report_flags.show_blocked', 'Show Blocked Products') ?></label>
  </div>
  <div class="mb-2"><label class="form-label"><?= __('common.sort_order', 'Sort Order') ?></label><input name="sort_order" value="<?= htmlspecialchars($flag['sort_order']) ?>" class="form-control form-control-sm"></div>
  <div class="form-check mb-2"><input type="checkbox" class="form-check-input" id="rf_active" name="is_active" <?= $flag['is_active']?'checked':'' ?>><label for="rf_active" class="form-check-label"><?= __("common.active", "Active") ?></label></div>
  <button class="btn btn-primary"><?= __("common.update", "Update") ?></button> <a class="btn btn-secondary" href="/samanta_crm/report-flags"><?= __("common.cancel", "Cancel") ?></a>
</form>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
