<?php $title=__('products.products', 'Products'); ob_start(); ?>
<?php
// Helper to safely escape possibly null values
if(!function_exists('h')){ function h($v){ return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8'); } }
?>
<div class="d-flex justify-content-between mb-3"><h3><?= __('products.products', 'Products') ?></h3>
  <div class="btn-group">
    <a href="/samanta_crm/products/create" class="btn btn-primary btn-sm"><i class="fas fa-plus"></i> <?= __('common.add', 'Add') ?></a>
    <a href="/samanta_crm/products/import" class="btn btn-outline-secondary btn-sm"><i class="fas fa-file-import"></i> <?= __('common.import', 'Import') ?></a>
  </div>
</div>
<form class="row g-2 align-items-end mb-3">
  <div class="col-md-2 col-6"><label class="form-label small mb-0"><?= __('common.search', 'Search') ?></label><input type="text" name="q" value="<?= h($filter_q ?? '') ?>" class="form-control form-control-sm" placeholder="<?= __('common.search', 'Search') ?>"></div>
  <div class="col-md-2 col-6"><label class="form-label small mb-0"><?= __('common.category', 'Category') ?></label><select name="category" class="form-select form-select-sm"><option value=""><?= __('common.all', 'All') ?></option><?php foreach($categories as $c): ?><option value="<?= $c['id'] ?>" <?= $filter_category==$c['id']?'selected':'' ?>><?= h($c['name'] ?? '') ?></option><?php endforeach; ?></select></div>
  <div class="col-md-2 col-6"><label class="form-label small mb-0"><?= __('common.status', 'Status') ?></label><select name="status" class="form-select form-select-sm"><option value="all"><?= __('common.all', 'All') ?></option><option value="active" <?= $filter_status=='active'?'selected':'' ?>><?= __('common.active', 'Active') ?></option><option value="notactive" <?= $filter_status=='notactive'?'selected':'' ?>><?= __('common.inactive', 'Inactive') ?></option><option value="blocked" <?= $filter_status=='blocked'?'selected':'' ?>><?= __('common.blocked', 'Blocked') ?></option></select></div>
  <div class="col-md-2 col-6"><label class="form-label small mb-0"><?= __('common.page_size', 'Page Size') ?></label><select name="ps" class="form-select form-select-sm"><?php foreach([10,25,50,100,200] as $ps): ?><option value="<?= $ps ?>" <?= ($pageSize??25)==$ps?'selected':'' ?>><?= $ps ?></option><?php endforeach; ?></select></div>
  <div class="col-auto"><button class="btn btn-sm btn-outline-secondary"><?= __('common.filter', 'Filter') ?></button></div>
  <input type="hidden" name="sort" value="<?= h($sort) ?>"><input type="hidden" name="dir" value="<?= h($dir) ?>">
</form>
<form method="POST" action="/samanta_crm/products/bulk-delete" id="bulkForm" onsubmit="return confirm('Delete selected products?');">
<div class="d-flex flex-wrap justify-content-between gap-2 mb-1 align-items-center">
  <div class="d-flex gap-2">
    <button type="submit" class="btn btn-sm btn-outline-danger" disabled id="bulkDeleteBtn"><i class="fas fa-trash"></i> <?= __('common.remove_selected', 'Remove Selected') ?></button>
    <div class="dropdown">
      <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown"><?= __('common.columns', 'Columns') ?></button>
      <div class="dropdown-menu p-2 small" style="min-width:220px" id="colChooser">
        <!-- dynamically filled -->
        <div class="text-muted small mb-1"><?= __('common.show_hide', 'Show / Hide') ?></div>
        <div id="colChooserList"></div>
        <hr class="my-1">
        <button type="button" class="btn btn-sm btn-outline-primary w-100" id="applyFiltersBtn"><?= __('common.apply_filters', 'Apply Filters') ?></button>
      </div>
    </div>
  </div>
  <div class="small text-muted" id="selCount"></div>
</div>
<table class="table table-sm table-hover align-middle" id="productsTable">
  <thead>
    <tr>
  <th data-col="select" style="width:28px"><input type="checkbox" id="checkAll"></th>
      <?php
        $cols=[ 'code'=>'Code','name'=>__('common.name', 'Name'),'category_name'=>'Category','price'=>'Price','status'=>__('common.status', 'Status') ];
        $sortMap=[ 'code'=>'code','name'=>'name','category_name'=>'name','price'=>'price','status'=>'status' ];
        $filter_q_str=(string)($filter_q ?? '');
        $filter_category_str=(string)($filter_category ?? '');
        $filter_status_str=(string)($filter_status ?? 'all');
        $queryBase=function($col) use($filter_q_str,$filter_category_str,$filter_status_str,$sort,$dir,$sortMap){
          $newDir = ($sortMap[$col]??'name')===$sort && $dir==='asc'?'desc':'asc';
          return '?q='.urlencode($filter_q_str)
            .'&category='.urlencode($filter_category_str)
            .'&status='.urlencode($filter_status_str)
            .'&sort='.urlencode($sortMap[$col]??'name')
            .'&dir='.$newDir; };
      ?>
      <th data-col="code"><a href="<?= $queryBase('code') ?>" class="text-decoration-none"><?= __('common.code', 'Code') ?><?= $sort==='code'?' '.($dir==='asc'?'▲':'▼'):'' ?></a></th>
      <th data-col="name"><a href="<?= $queryBase('name') ?>" class="text-decoration-none"><?= __('common.name', 'Name') ?><?= $sort==='name'?' '.($dir==='asc'?'▲':'▼'):'' ?></a></th>
      <th data-col="category"><a href="<?= $queryBase('category') ?>" class="text-decoration-none"><?= __('common.category', 'Category') ?><?= $sort==='category'?' '.($dir==='asc'?'▲':'▼'):'' ?></a></th>
      <th data-col="price"><a href="<?= $queryBase('price') ?>" class="text-decoration-none"><?= __('common.price', 'Price') ?><?= $sort==='price'?' '.($dir==='asc'?'▲':'▼'):'' ?></a></th>
      <th data-col="status"><a href="<?= $queryBase('status') ?>" class="text-decoration-none"><?= __('common.status', 'Status') ?><?= $sort==='status'?' '.($dir==='asc'?'▲':'▼'):'' ?></a></th>
      <th data-col="sort_order"><a href="<?= $queryBase('sort_order') ?>" class="text-decoration-none"><?= __('common.sort', 'Sort') ?><?= $sort==='sort_order'?' '.($dir==='asc'?'▲':'▼'):'' ?></a></th>
      <?php
        $explicitHead=['code','name','category','price','status','sort_order'];
        foreach(($db_columns ?? []) as $dbc){ if(in_array($dbc,$explicitHead)) continue; echo '<th class="d-none" data-col="'.h($dbc).'">'.h(ucwords(str_replace('_',' ',$dbc))).'</th>'; }
      ?>
      <th data-col="actions"></th>
    </tr>
    <tr id="filterRow" class="align-middle"></tr>
  </thead>
  <tbody id="productTableBody" data-sortable="1"><?php foreach($products as $p): ?><tr data-id="<?= $p['id'] ?>">
    <td data-col="select"><input type="checkbox" name="ids[]" value="<?= $p['id'] ?>" class="rowCheck"></td>
  <td data-col="code" class="text-muted cursor-move editable" data-field="code" style="cursor:move" title="Drag to reorder / dblclick to edit">☰ <span class="cell-value"><?= h($p['code'] ?? '') ?></span></td>
  <td data-col="name" class="editable" data-field="name"><span class="cell-value"><?= h($p['name'] ?? '') ?></span></td>
  <td data-col="category" class="editable" data-field="category_id" data-type="select" data-source="category"><span class="cell-value" data-id="<?= h($p['category_id'] ?? '') ?>"><?= h($p['category_name'] ?? '') ?></span></td>
  <td data-col="price" class="editable" data-field="price"><span class="cell-value"><?= $p['price']!==null ? number_format($p['price'],2).' '.h($p['price_unit'] ?? ''):'' ?></span></td>
  <td data-col="status" class="editable" data-field="status" data-type="select" data-source="status"><span class="badge cell-value bg-<?= ($p['status']??'')=='active'?'success':(($p['status']??'')=='blocked'?'danger':'secondary') ?>" data-id="<?= h($p['status'] ?? '') ?>"><?= h($p['status'] ?? '') ?></span></td>
  <td data-col="sort_order" class="editable" data-field="sort_order"><span class="cell-value"><?= (int)($p['sort_order'] ?? 0) ?></span></td>
    <?php
      $explicitCell=['code','name','category','price','status','sort_order'];
      foreach(($db_columns ?? []) as $dbc){ if(in_array($dbc,$explicitCell)) continue; $val=$p[$dbc]??''; if($dbc==='report_flags'){ if(is_string($val)){ $decoded=json_decode($val,true); if(json_last_error()===JSON_ERROR_NONE) $val=implode(',', $decoded); } elseif(is_array($val)) { $val=implode(',',$val); } }
        echo '<td class="d-none" data-col="'.h($dbc).'">'.h(is_scalar($val)? $val : '').'</td>'; }
    ?>
    <td data-col="actions" class="text-end">
      <a href="/samanta_crm/products/<?= $p['id'] ?>/edit" class="btn btn-sm btn-outline-primary"><?= __('common.edit', 'Edit') ?></a>
      <form action="/samanta_crm/products/<?= $p['id'] ?>/delete" method="POST" class="d-inline" onsubmit="return confirm('<?= __('products.confirm_delete', 'Delete product?') ?>')">
        <button class="btn btn-sm btn-outline-danger"><?= __('common.delete', 'Del') ?></button>
      </form>
    </td>
  </tr><?php endforeach; ?></tbody>
</table>
</form>
<?php if(($pages??1) > 1): ?>
<nav aria-label="Pagination" class="mt-2">
  <ul class="pagination pagination-sm mb-0">
    <?php
      $baseParams = function($p) use($filter_q_str,$filter_category_str,$filter_status_str,$sort,$dir,$pageSize){
        return '?q='.urlencode($filter_q_str).'&category='.urlencode($filter_category_str).'&status='.urlencode($filter_status_str).'&sort='.urlencode($sort).'&dir='.urlencode($dir).'&ps='.urlencode($pageSize).'&page='.$p; };
      for($p=1;$p<=$pages;$p++): ?>
        <li class="page-item <?= $p==($page??1)?'active':'' ?>"><a class="page-link" href="<?= $baseParams($p) ?>"><?= $p ?></a></li>
    <?php endfor; ?>
  </ul>
</nav>
<div class="small text-muted mt-1"><?= __('common.total', 'Total') ?>: <?= (int)$total ?> <?= __('common.items', 'items') ?></div>
<?php endif; ?>
<script>
(function(){
  // Column visibility + filters
  const STORAGE_COLS='productColumnsVisible';
  const STORAGE_FILTERS='productColumnFilters';
  // Build dynamic columns from backend provided schema
  const dbCols = <?php echo json_encode($db_columns ?? []); ?>;
  // Map DB column to display alias if needed
  const aliasMap = { category_id:'category', report_flags:'flags' };
  const baseCols=['select'];
  const derived=['category','price','status','sort_order']; // existing computed / interest columns
  let allColumns = Array.from(new Set(baseCols.concat(dbCols.map(c=>aliasMap[c]||c)).concat(['actions'])));
  if(!allColumns.includes('category')) allColumns.splice( allColumns.indexOf('category_id')!==-1? allColumns.indexOf('category_id')+1 : 2, 0, 'category');
  const filterable = allColumns.filter(c=>['select','actions','report_flags','notes','description'].indexOf(c)===-1); // hide some large text by default
  let visible = JSON.parse(localStorage.getItem(STORAGE_COLS) || 'null') || ['select','code','name','category','price','status','sort_order','actions'];
  if(!visible.includes('select')) visible.unshift('select');
  if(!visible.includes('actions')) visible.push('actions');
  const table=document.getElementById('productsTable');
  function applyVisibility(){
    // Show/hide cells according to visibility selection
    const headerOrder = getHeaderCols();
    headerOrder.forEach(col=>{
      const show = visible.includes(col) || col==='select' || col==='actions';
      table.querySelectorAll('[data-col="'+col+'"]').forEach(el=>{ if(show) el.classList.remove('d-none'); else el.classList.add('d-none'); });
    });
    buildFilterRow();
  }
  const chooserList=document.getElementById('colChooserList');
  if(chooserList){
    allColumns.forEach(col=>{
      if(col==='select'||col==='actions') return; // always present but toggle allowed? keep ability
      const id='col_'+col;
      const wrap=document.createElement('div'); wrap.className='form-check';
      wrap.innerHTML='<input class="form-check-input" type="checkbox" id="'+id+'"> <label class="form-check-label" for="'+id+'">'+col.replace('_',' ')+'</label>';
      const chk=wrap.querySelector('input'); chk.checked=visible.includes(col);
      chk.addEventListener('change',()=>{ if(chk.checked){ if(!visible.includes(col)) visible.push(col); } else { visible=visible.filter(c=>c!==col); } localStorage.setItem(STORAGE_COLS, JSON.stringify(visible)); applyVisibility(); });
      chooserList.appendChild(wrap);
    });
  }
  // Filters
  const filterRow=document.getElementById('filterRow');
  let filters = JSON.parse(localStorage.getItem(STORAGE_FILTERS) || '{}');
  function getHeaderCols(){
    return Array.from(document.querySelectorAll('#productsTable thead tr:first-child th[data-col]'))
      .map(th=>th.getAttribute('data-col'));
  }
  function buildFilterRow(){
    if(!filterRow) return; filterRow.innerHTML='';
    const headerCols = getHeaderCols();
    headerCols.forEach(col=>{
      const cell=document.createElement('th'); cell.dataset.col=col;
      const colHidden = !visible.includes(col) && col!=='select' && col!=='actions';
      if(colHidden) cell.classList.add('d-none');
      if(filterable.includes(col) && !colHidden){
        if(col==='status'){
          const sel=document.createElement('select'); sel.className='form-select form-select-sm'; sel.innerHTML='<option value="">*</option><option value="active">active</option><option value="notactive">notactive</option><option value="blocked">blocked</option>'; sel.value=filters[col]||''; sel.onchange=()=>{ filters[col]=sel.value; persistFilters(); applyFilters(); }; cell.appendChild(sel);
        } else {
          const input=document.createElement('input'); input.type='text'; input.className='form-control form-control-sm'; input.placeholder='filter'; input.value=filters[col]||''; input.oninput=()=>{ filters[col]=input.value; persistFilters(); applyFilters(); }; cell.appendChild(input);
        }
      }
      filterRow.appendChild(cell);
    });
  }
  function persistFilters(){ localStorage.setItem(STORAGE_FILTERS, JSON.stringify(filters)); }
  function applyFilters(){
    const rows=[...document.querySelectorAll('#productTableBody tr')];
    rows.forEach(r=>{
      let show=true;
      for(const col of filterable){
        if(filters[col]){
          const cell=r.querySelector('[data-col="'+col+'"]');
          const txt=(cell? cell.innerText : '').toLowerCase();
            if(!txt.includes(filters[col].toLowerCase())){ show=false; break; }
        }
      }
      r.style.display=show?'' : 'none';
    });
  }
  applyVisibility();
  applyFilters();
  const checkAll=document.getElementById('checkAll');
  const checks=[...document.querySelectorAll('.rowCheck')];
  const bulkBtn=document.getElementById('bulkDeleteBtn');
  const selCount=document.getElementById('selCount');
  function update(){
    const selected=checks.filter(c=>c.checked).length;
    bulkBtn.disabled=selected===0; selCount.textContent=selected? selected+ ' selected' : '';
    if(selected===checks.length){ checkAll.indeterminate=false; checkAll.checked=true; }
    else if(selected===0){ checkAll.indeterminate=false; checkAll.checked=false; }
    else { checkAll.indeterminate=true; }
  }
  checkAll && (checkAll.onchange=()=>{ checks.forEach(c=>c.checked=checkAll.checked); update(); });
  checks.forEach(c=>c.addEventListener('change',update));
  // Drag & drop reorder (simple HTML5 API)
  const tbody=document.getElementById('productTableBody');
  if(tbody){
    let draggingRow=null; let startIndex=null;
    tbody.querySelectorAll('tr').forEach(tr=>{ tr.draggable=true; tr.addEventListener('dragstart',e=>{ draggingRow=tr; startIndex=[...tbody.children].indexOf(tr); e.dataTransfer.effectAllowed='move'; tr.classList.add('opacity-50'); }); tr.addEventListener('dragend',()=>{ if(draggingRow){ draggingRow.classList.remove('opacity-50'); draggingRow=null; } }); tr.addEventListener('dragover',e=>{ e.preventDefault(); const target=tr; if(!draggingRow || target===draggingRow) return; const rows=[...tbody.children]; const targetIndex=rows.indexOf(target); if(targetIndex>rows.indexOf(draggingRow)) target.after(draggingRow); else target.before(draggingRow); }); });
    tbody.addEventListener('drop',()=>{ saveOrder(); });
    function saveOrder(){ const ids=[...tbody.querySelectorAll('tr')].map(r=>r.getAttribute('data-id')); fetch('/samanta_crm/products/save-order',{ method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body: ids.map(id=>'order[]='+encodeURIComponent(id)).join('&') })
      .then(r=>r.json()).then(j=>{ if(!j.success){ alert('Failed to save order'); } }); }
  }
  // Inline editing with support for select fields
  const DATA_CATEGORIES = <?php echo json_encode(array_map(fn($c)=>['id'=>$c['id'],'name'=>$c['name']], $categories)); ?>;
  const DATA_STATUS = ['active','notactive','blocked'];
  function makeEditable(td){
    if(td.classList.contains('editing')) return; const field=td.dataset.field; if(!field) return;
    const row=td.closest('tr'); const id=row.getAttribute('data-id');
    const span=td.querySelector('.cell-value'); const original=span?span.textContent.trim():''; const originalId=span? span.getAttribute('data-id') || original : original;
    td.classList.add('editing');
    let input;
    if(td.dataset.type==='select'){
      input=document.createElement('select'); input.className='form-select form-select-sm';
      let source=[]; if(td.dataset.source==='status'){ source=DATA_STATUS.map(s=>({value:s,label:s})); }
      else if(td.dataset.source==='category'){ source=DATA_CATEGORIES.map(c=>({value:c.id,label:c.name})); }
      source.forEach(opt=>{ const o=document.createElement('option'); o.value=opt.value; o.textContent=opt.label; if(String(opt.value)===String(originalId)) o.selected=true; input.appendChild(o); });
    } else { input=document.createElement('input'); input.type='text'; input.className='form-control form-control-sm'; input.value=original; }
    span && span.classList.add('d-none'); td.appendChild(input); input.focus(); if(input.select) input.select();
    function cancel(){ td.classList.remove('editing'); if(span) span.classList.remove('d-none'); input.remove(); }
    function commit(){ const newVal=(input.tagName==='SELECT'? input.value : input.value.trim()); if(newVal===originalId){ cancel(); return; }
      const formData=new URLSearchParams(); formData.append('id',id); formData.append('field',field); formData.append('value',newVal);
      fetch('/samanta_crm/products/inline-update',{method:'POST',headers:{'Content-Type':'application/x-www-form-urlencoded'},body:formData.toString()})
        .then(r=>r.json()).then(j=>{ if(j.success){ if(field==='status'){ span.textContent=j.value; span.setAttribute('data-id',j.value); span.className='badge cell-value bg-'+(j.value==='active'?'success':(j.value==='blocked'?'danger':'secondary')); } else if(field==='category_id'){ const match=DATA_CATEGORIES.find(c=>String(c.id)===String(j.value)); span.textContent=match?match.name:''; span.setAttribute('data-id',j.value); } else { span.textContent=j.value; } cancel(); } else { alert(j.error||'Save failed'); cancel(); } })
        .catch(()=>{ alert('Network error'); cancel(); });
    }
    input.addEventListener('keydown',e=>{ if(e.key==='Enter'){ e.preventDefault(); commit(); } else if(e.key==='Escape'){ e.preventDefault(); cancel(); } });
    if(input.tagName==='SELECT') input.addEventListener('change',commit);
    input.addEventListener('blur',()=>{ setTimeout(()=>{ if(td.contains(input)) cancel(); },150); });
  }
  document.querySelectorAll('#productTableBody td.editable').forEach(td=>{
    td.addEventListener('dblclick',()=>makeEditable(td));
  });
})();
</script>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
