<?php $title='Map Product Import Fields'; ob_start(); ?>
<h3>Map Fields</h3>
<p class="text-muted small">Match each CSV column to a product field. Leave unmapped to ignore. Flags treat any non-empty value as selected.</p>
<?php if(isset($meta)): ?>
<div class="alert alert-secondary py-1 px-2 small mb-2">Detected Delimiters: Field <strong><?= $meta['field_delim']==="\t"? 'TAB': htmlspecialchars($meta['field_delim']) ?></strong>, Text <strong><?= htmlspecialchars($meta['text_delim']) ?></strong></div>
<?php endif; ?>
<form method="POST" action="/samanta_crm/products/import/process">
  <?php if(isset($meta)): ?>
    <input type="hidden" name="_field_delim" value="<?= htmlspecialchars($meta['field_delim']) ?>">
    <input type="hidden" name="_text_delim" value="<?= htmlspecialchars($meta['text_delim']) ?>">
  <?php endif; ?>
  <div class="table-responsive mb-3">
    <table class="table table-sm table-bordered align-middle">
      <thead><tr><th>#</th><th>CSV Column</th><th>Sample Values</th><th>Map To</th></tr></thead>
      <tbody>
        <?php foreach($header as $i=>$col): $samples=[]; foreach($sample as $r){ $samples[] = htmlspecialchars($r[$i] ?? ''); } $samples = array_filter(array_unique($samples)); ?>
        <tr>
          <td><?= $i ?></td>
          <td><code><?= htmlspecialchars($col) ?></code></td>
          <td class="small text-muted" style="max-width:220px;">
            <?php foreach(array_slice($samples,0,3) as $sv): ?>
              <div><?= $sv===''?'<span class="text-muted">(empty)</span>':$sv ?></div>
            <?php endforeach; ?>
          </td>
          <td>
            <select name="map[<?= $i ?>]" class="form-select form-select-sm">
              <option value="">-- Ignore --</option>
              <?php foreach($fields as $k=>$label): ?>
                <option value="<?= $k ?>" <?= autoSelect($col,$k)?'selected':'' ?>><?= htmlspecialchars($label) ?></option>
              <?php endforeach; ?>
            </select>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <div class="alert alert-info p-2 small">Unique key is <strong>Code</strong>. If mapped and exists, product will be updated.</div>
  <button class="btn btn-primary"><i class="fas fa-play"></i> Process Import</button>
  <a href="/samanta_crm/products/import" class="btn btn-secondary">Back</a>
</form>
<?php
function autoSelect($csvCol,$fieldKey){
  $c = mb_strtolower(trim($csvCol),'UTF-8');
  $map = [
    'nazwa'=>'name','opis'=>'description','kategoria'=>'category_id','cena'=>'price','za ceną'=>'price_unit','uwagi'=>'notes','produkcja'=>'production_site','kod'=>'code','order'=>'sort_order','faktor'=>'factor','jed. prod.'=>'production_unit','status'=>'status','ogólny'=>'flag:ogolny','kategoria'=>'flag:kategoria','piekarnia'=>'flag:piekarnia','cukiernia'=>'flag:cukiernia','lodziarnia'=>'flag:lodziarnia','magazyn'=>'flag:magazyn','wydawka 1'=>'flag:wydawka1','wydawka 2'=>'flag:wydawka2'
  ];
  return isset($map[$c]) && $map[$c]===$fieldKey;
}
?>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
