<?php $title=__('orders.order_number', 'Order #').($order['id']??''); ob_start(); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h3 mb-0"><?= strtoupper(__('orders.order', 'Order')) ?> #<?= $order['id'] ?></h1>
  <div class="btn-group">
    <a href="/samanta_crm/orders/<?= $order['id'] ?>/edit" class="btn btn-sm btn-outline-secondary"><i class="fas fa-edit"></i> <?= __('common.edit', 'Edit') ?></a>
    <a href="/samanta_crm/orders/<?= $order['id'] ?>?export=csv" class="btn btn-sm btn-outline-success"><i class="fas fa-file-csv"></i> CSV</a>
    <a href="/samanta_crm/orders/<?= $order['id'] ?>?export=excel" class="btn btn-sm btn-outline-success"><i class="fas fa-file-excel"></i> Excel</a>
    <a href="/samanta_crm/orders" class="btn btn-sm btn-outline-primary"><i class="fas fa-arrow-left"></i> <?= __('common.back', 'Back') ?></a>
    <button onclick="window.print()" class="btn btn-sm btn-outline-dark"><i class="fas fa-print"></i> <?= __('common.print', 'Print') ?></button>
  </div>
</div>
<!-- Document Header -->
<div class="border border-dark mb-4">
  <div class="bg-light border-bottom border-dark p-3">
    <div class="row">
      <div class="col-6">
        <h4 class="mb-0 text-uppercase fw-bold"><?= strtoupper(__('orders.order_details', 'Order Details')) ?></h4>
      </div>
      <div class="col-6 text-end">
        <div class="fw-bold"><?= __('common.date', 'Date') ?>: <?= date('Y-m-d') ?></div>
      </div>
    </div>
  </div>
  
  <div class="p-4">
    <div class="row mb-3">
      <div class="col-md-6">
        <table class="table table-borderless table-sm">
          <tr>
            <td class="fw-bold" style="width: 140px;"><?= __('common.customer', 'Customer') ?>:</td>
            <td><?= htmlspecialchars($order['customer_name']) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.order_date', 'Order Date') ?>:</td>
            <td><?= htmlspecialchars(date('Y-m-d', strtotime($order['order_date']))) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.order_time', 'Order Time') ?>:</td>
            <td><?= htmlspecialchars(date('H:i', strtotime($order['order_date']))) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.delivery_date', 'Delivery Date') ?>:</td>
            <td><?= htmlspecialchars($order['delivery_date'] ?? __('common.not_specified', 'Not specified')) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.order_type', 'Order Type') ?>:</td>
            <td class="text-capitalize"><?= htmlspecialchars($order['order_type'] ?? 'daily') ?></td>
          </tr>
        </table>
      </div>
      <div class="col-md-6">
        <table class="table table-borderless table-sm">
          <tr>
            <td class="fw-bold" style="width: 140px;"><?= __('common.status', 'Status') ?>:</td>
            <td class="text-capitalize"><?= htmlspecialchars($order['status']) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.assigned_user', 'Assigned User') ?>:</td>
            <td><?= htmlspecialchars($order['assigned_user_name'] ?? __('common.not_assigned', 'Not assigned')) ?></td>
          </tr>
          <tr>
            <td class="fw-bold"><?= __('orders.verified', 'Verified') ?>:</td>
            <td><?= !empty($order['confirmed']) ? __('common.yes', 'Yes') : __('common.no', 'No') ?></td>
          </tr>
          <?php if(!empty($order['notes'])): ?>
          <tr>
            <td class="fw-bold"><?= __('common.notes', 'Notes') ?>:</td>
            <td><?= nl2br(htmlspecialchars($order['notes'])) ?></td>
          </tr>
          <?php endif; ?>
          <?php if(!empty($order['signature'])): ?>
          <tr>
            <td class="fw-bold"><?= __('orders.signature', 'Signature') ?>:</td>
            <td><?= nl2br(htmlspecialchars($order['signature'])) ?></td>
          </tr>
          <?php endif; ?>
        </table>
      </div>
    </div>
  </div>
</div>
<!-- Items Section -->
<div class="border border-dark">
  <div class="bg-light border-bottom border-dark p-3">
    <h5 class="mb-0 text-uppercase fw-bold"><?= strtoupper(__('orders.order_items', 'Order Items')) ?></h5>
  </div>
  <div class="p-0">
    <table class="table table-striped table-bordered mb-0">
      <thead class="table-dark">
        <tr>
          <th style="width:100px"><?= __('common.code', 'Code') ?></th>
          <th><?= __('common.name', 'Name') ?></th>
          <th style="width:80px" class="text-center"><?= __('common.quantity', 'Qty') ?></th>
          <th style="width:80px" class="text-center"><?= __('common.units', 'Units') ?></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($items as $it): $qty=(float)$it['quantity']; ?>
          <tr>
            <td><?= htmlspecialchars(($it['product_code_snapshot']??'') ?: ($it['code']??'')) ?></td>
            <td><?= htmlspecialchars(($it['product_name_snapshot']??'') ?: ($it['name']??'')) ?></td>
            <td class="text-center"><?= number_format($qty,1) ?></td>
            <td class="text-center"><?= htmlspecialchars(($it['price_unit'] ?? '') ?: ($it['production_unit'] ?? '')) ?></td>
          </tr>
        <?php endforeach; if(!$items): ?>
          <tr><td colspan="4" class="text-muted text-center py-3"><?= __('orders.no_items', 'No items in this order') ?></td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<style>@media print{body{background:#fff;} .btn,.btn-group,nav,.navbar,form{display:none!important;} .border,.border-dark{border:1px solid #000!important;} .bg-light{background:#f8f9fa!important;} }</style>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
