<?php $title=__('orders.orders', 'Orders'); ob_start(); ?>
<h1 class="h4 mb-3"><i class="fas fa-receipt me-2"></i><?= __('orders.orders', 'Orders') ?></h1>
<div class="mb-3">
  <a href="/samanta_crm/orders/create" class="btn btn-primary btn-sm"><i class="fas fa-plus me-1"></i><?= __('orders.new_order', 'New Order') ?></a>
  <a href="/samanta_crm/orders?export=csv" class="btn btn-outline-secondary btn-sm"><i class="fas fa-file-csv me-1"></i>CSV</a>
  <a href="/samanta_crm/orders?export=excel" class="btn btn-outline-secondary btn-sm"><i class="fas fa-file-excel me-1"></i>Excel</a>
  <a href="/samanta_crm/orders/panel" class="btn btn-outline-info btn-sm"><i class="fas fa-tablet-alt me-1"></i><?= __('orders.tablet_panel', 'Tablet Panel') ?></a>
</div>
<form class="row g-2 mb-3" method="GET" action="/samanta_crm/orders">
  <div class="col-6 col-md-2"><input type="date" name="date_from" value="<?=htmlspecialchars($filters['date_from'] ?? '', ENT_QUOTES, 'UTF-8')?>" class="form-control form-control-sm" placeholder="<?= __('common.from', 'From') ?>"></div>
  <div class="col-6 col-md-2"><input type="date" name="date_to" value="<?=htmlspecialchars($filters['date_to'] ?? '', ENT_QUOTES, 'UTF-8')?>" class="form-control form-control-sm" placeholder="<?= __('common.to', 'To') ?>"></div>
  <div class="col-6 col-md-3">
    <select name="customer_id" class="form-select form-select-sm">
      <option value=""><?= __('common.customer', 'Customer') ?>...</option>
      <?php foreach($customers as $c): ?>
  <option value="<?=$c['id'];?>" <?=$filters['customer_id']==$c['id']?'selected':'';?>><?=htmlspecialchars($c['name'] ?? '', ENT_QUOTES, 'UTF-8');?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-6 col-md-2">
    <select name="order_type" class="form-select form-select-sm">
      <option value=""><?= __('common.type', 'Type') ?>...</option>
      <?php if(isset($orderTypes)) foreach($orderTypes as $ot): ?>
        <option value="<?= htmlspecialchars($ot, ENT_QUOTES, 'UTF-8') ?>" <?=$filters['order_type']==$ot?'selected':'';?>><?=ucfirst(htmlspecialchars($ot, ENT_QUOTES, 'UTF-8'))?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-6 col-md-2">
    <select name="status" class="form-select form-select-sm">
      <option value=""><?= __('common.status', 'Status') ?>...</option>
      <?php foreach(['pending','processing','completed','cancelled'] as $st): ?>
        <option value="<?=$st?>" <?=$filters['status']==$st?'selected':'';?>><?=ucfirst($st)?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-6 col-md-2">
    <select name="verified" class="form-select form-select-sm">
      <option value=""><?= __('orders.verified', 'Verified') ?>?</option>
      <option value="1" <?=$filters['verified']==='1'?'selected':'';?>><?= __('common.yes', 'Yes') ?></option>
      <option value="0" <?=$filters['verified']==='0'?'selected':'';?>><?= __('common.no', 'No') ?></option>
    </select>
  </div>
  <div class="col-6 col-md-1 d-grid">
    <button class="btn btn-sm btn-secondary"><i class="fas fa-filter"></i></button>
  </div>
</form>
<div class="table-responsive">
<table class="table table-sm table-hover align-middle">
  <thead class="table-light">
    <tr>
      <th>ID</th><th><?= __('orders.order_date', 'Order Date') ?></th><th><?= __('orders.delivery_date', 'Delivery Date') ?></th><th><?= __("common.type", "Type") ?></th><th><?= __('common.customer', 'Customer') ?></th><th><?= __('orders.assigned', 'Assigned') ?></th><th><?= __("common.status", "Status") ?></th><th><?= __('orders.items', 'Items') ?></th><th><?= __('orders.verified', 'Verified') ?></th><th></th>
    </tr>
  </thead>
  <tbody>
    <?php if(empty($orders)): ?>
      <tr><td colspan="10" class="text-center text-muted py-4"><?= __('orders.no_orders_found', 'No orders found') ?></td></tr>
    <?php else: ?>
      <?php foreach($orders as $o): ?>
        <tr>
          <td><?=$o['id']?></td>
          <td><?=htmlspecialchars($o['order_date'] ?? '', ENT_QUOTES, 'UTF-8')?></td>
          <td><?=htmlspecialchars($o['delivery_date'] ?? '', ENT_QUOTES, 'UTF-8')?></td>
          <td><?=htmlspecialchars($o['order_type'] ?? '', ENT_QUOTES, 'UTF-8')?></td>
          <td><?=htmlspecialchars($o['customer_name'] ?? '', ENT_QUOTES, 'UTF-8')?></td>
          <td><?=htmlspecialchars($o['assigned_user_name'] ?? '', ENT_QUOTES, 'UTF-8')?></td>
          <td><span class="badge bg-<?= $o['status']==='completed'?'success':($o['status']==='cancelled'?'danger':'secondary'); ?>"><?=htmlspecialchars($o['status'] ?? '', ENT_QUOTES, 'UTF-8')?></span></td>
          <td><?= (int)($o['items_count'] ?? 0) ?></td>
          <td><?= $o['confirmed']?'<i class="fas fa-check text-success"></i>':'' ?></td>
          <td class="text-end">
            <div class="btn-group btn-group-sm">
              <a href="/samanta_crm/orders/<?=$o['id']?>" class="btn btn-outline-secondary" title="<?= __('common.show', 'Show') ?>"><i class="fas fa-eye"></i></a>
              <a href="/samanta_crm/orders/<?=$o['id']?>/edit" class="btn btn-outline-primary" title="<?= __('common.edit', 'Edit') ?>"><i class="fas fa-edit"></i></a>
              <form method="POST" action="/samanta_crm/orders/<?=$o['id']?>/delete" onsubmit="return confirm('<?= __('orders.confirm_delete', 'Delete order') ?> #<?=$o['id']?>?');" class="d-inline">
                <button class="btn btn-outline-danger" title="<?= __('common.delete', 'Delete') ?>"><i class="fas fa-trash"></i></button>
              </form>
            </div>
          </td>
        </tr>
      <?php endforeach; ?>
    <?php endif; ?>
  </tbody>
</table>
</div>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
