<?php
// Ensure translation helper is available
require_once __DIR__ . '/../helpers/translation.php';
?>
<!DOCTYPE html>
<html lang="<?= Translation::getCurrentLanguage() ?>" dir="<?= getTextDirection() ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php 
    $settingPath = __DIR__ . '/../Models/Setting.php';
    if (file_exists($settingPath)) {
        require_once $settingPath; 
    }
    ?>
    <?php $siteName = get_setting('site_name', __('app.name')); ?>
    <title><?= $title ? $siteName . ' - ' . htmlspecialchars($title) : $siteName ?></title>
    <link rel="icon" type="image/png" href="/samanta_crm/public/assets/images/png/favicon.png">
    <link rel="apple-touch-icon" href="/samanta_crm/public/assets/images/png/favicon.png">
    <link href="/samanta_crm/assets/fonts/noto-color-emoji.css" rel="stylesheet">
   <!-- <link href="/samanta_crm/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet"> -->
    <link href="https://cdn.jsdelivr.net/npm/bootswatch@5.3.8/dist/pulse/bootstrap.min.css" rel="stylesheet">
    <link href="/samanta_crm/assets/vendor/fontawesome/css/all.min.css" rel="stylesheet">
    <link href="/samanta_crm/assets/css/app.css" rel="stylesheet">
</head>
<body>
    <?php if (isset($_SESSION['user_id'])): ?>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary p-2">
        <div class="container">
                        <a class="navbar-brand d-flex align-items-center" href="/samanta_crm/dashboard">
                                <?php $logo = get_setting('site_logo',''); $showName = get_setting('show_site_name_with_logo','1')==='1'; if($logo): ?>
                                    <img src="<?= htmlspecialchars($logo) ?>" alt="Logo" style="height:48px" class="me-2">
                                <?php else: ?>
                                    <i class="fas fa-users me-1"></i>
                                <?php endif; ?>
                                <?php if(!$logo || $showName): ?><span><?= htmlspecialchars($siteName) ?></span><?php endif; ?>
                        </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="/samanta_crm/dashboard">
                            <i class="fas fa-tachometer-alt"></i> <?= __('nav.dashboard') ?>
                        </a>
                    </li>
                    <!-- Catalog Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="catalogDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-boxes"></i> Catalog
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="catalogDropdown">
                            <li><a class="dropdown-item" href="/samanta_crm/products"><i class="fas fa-box"></i> Products</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/categories"><i class="fas fa-layer-group"></i> Categories</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/ingredients"><i class="fas fa-carrot"></i> Ingredients</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/units"><i class="fas fa-ruler-combined"></i> Units</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="/samanta_crm/customers"><i class="fas fa-user-group"></i> Customers / Receivers</a></li>
                        </ul>
                    </li>

                    <!-- Production Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="productionDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-industry"></i> Production
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="productionDropdown">
                            <li><a class="dropdown-item" href="/samanta_crm/production-sites"><i class="fas fa-industry"></i> Production Sites</a></li>
                        </ul>
                    </li>

                    <!-- Sales / Orders Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="ordersDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-receipt"></i> Orders
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="ordersDropdown">
                            <li><a class="dropdown-item" href="/samanta_crm/orders"><i class="fas fa-receipt"></i> Orders</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/orders/panel"><i class="fas fa-tablet-alt"></i> Tablet Panel</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/reports/daily"><i class="fas fa-calendar-day"></i> Daily Reports</a></li>
                        </ul>
                    </li>

                    <!-- Stock Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="stockDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-warehouse"></i> Stock
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="stockDropdown">
                            <li><a class="dropdown-item" href="/samanta_crm/stock/ingredients"><i class="fas fa-cubes"></i> Ingredient Stock</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/restocks"><i class="fas fa-truck-loading"></i> Restocks</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/stock/usage-history"><i class="fas fa-history"></i> Usage History</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/stock/usage-chart"><i class="fas fa-chart-line"></i> Usage Chart</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/stock/daily-usage"><i class="fas fa-calendar-check"></i> Daily Usage</a></li>
                        </ul>
                    </li>

                    <!-- Reports Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="reportsDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-chart-bar"></i> Reports
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="reportsDropdown">
                            <li><a class="dropdown-item" href="/samanta_crm/reports"><i class="fas fa-chart-line"></i> Reports</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/report-flags"><i class="fas fa-flag"></i> Report Flags</a></li>
                        </ul>
                    </li>
                    <?php if ($_SESSION['user_role'] === 'admin'): ?>
                    <!-- Admin Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cogs"></i> <?= __('nav.admin') ?>
                        </a>
                        <ul class="dropdown-menu">
                            <li class="dropdown-header text-uppercase small">User & Access</li>
                            <li><a class="dropdown-item" href="/samanta_crm/users"><i class="fas fa-users"></i> <?= __('nav.users') ?></a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/user-types"><i class="fas fa-tags"></i> <?= __('nav.user_types') ?></a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li class="dropdown-header text-uppercase small">Localization</li>
                            <li><a class="dropdown-item" href="/samanta_crm/languages"><i class="fas fa-language"></i> <?= __('nav.languages') ?></a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li class="dropdown-header text-uppercase small">System</li>
                            <li><a class="dropdown-item" href="/samanta_crm/settings"><i class="fas fa-sliders-h"></i> Settings</a></li>
                            <li><a class="dropdown-item" href="/samanta_crm/export"><i class="fas fa-file-export"></i> Export / Import</a></li>
                        </ul>
                    </li>
                    <?php endif; ?>
                </ul>
                
                <ul class="navbar-nav">
                    <!-- Language Switcher -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-globe"></i> 
                            <?php 
                            $currentLang = getCurrentLanguage();
                            echo $currentLang ? strtoupper($currentLang['code']) : 'EN';
                            ?>
                        </a>
                        <ul class="dropdown-menu">
                            <?php foreach (getAvailableLanguages() as $lang): ?>
                            <li>
                                <a class="dropdown-item" href="#" onclick="switchLanguage('<?= $lang['code'] ?>')">
                                    <?php if ($lang['flag']): ?>
                                        <?= $lang['flag'] ?> 
                                    <?php endif; ?>
                                    <?= htmlspecialchars($lang['native_name'] ?: $lang['name']) ?>
                                </a>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user"></i> <?= $_SESSION['user_name'] ?? 'User' ?>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/samanta_crm/logout">
                                <i class="fas fa-sign-out-alt"></i> <?= __('nav.logout') ?>
                            </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <?php endif; ?>

    <main class="<?= isset($_SESSION['user_id']) ? 'container mt-4' : '' ?>">
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= $_SESSION['success'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['success']); ?>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= $_SESSION['error'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['error']); ?>
        <?php endif; ?>

        <?= $content ?? '' ?>
    </main>

    <?php if (isset($_SESSION['user_id'])): ?>
    <footer class="mt-4 py-3 bg-light border-top small">
        <div class="container d-flex flex-wrap justify-content-between align-items-center gap-2">
            <span class="text-muted">&copy; <?= date('Y') ?> MyBakeryOS</span>
            <span class="text-muted">Created by <a href="https://nowagancy.pl" target="_blank" rel="noopener" class="text-decoration-none">nowagancy.pl</a></span>
        </div>
    </footer>
    <?php endif; ?>

    <script src="/samanta_crm/assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="/samanta_crm/assets/js/app.js"></script>
    <script>
    function switchLanguage(langCode) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '/samanta_crm/switch-language';
        
        const langInput = document.createElement('input');
        langInput.type = 'hidden';
        langInput.name = 'language';
        langInput.value = langCode;
        
        const redirectInput = document.createElement('input');
        redirectInput.type = 'hidden';
        redirectInput.name = 'redirect';
        redirectInput.value = window.location.pathname;
        
        form.appendChild(langInput);
        form.appendChild(redirectInput);
        document.body.appendChild(form);
        form.submit();
    }
    </script>
    <?= $scripts ?? '' ?>
</body>
</html>
