<?php 
$title = 'Edit Language';
ob_start(); 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-edit"></i> Edit Language: 
        <span class="badge bg-primary"><?= htmlspecialchars($language['name']) ?></span>
    </h1>
    <a href="/samanta_crm/languages" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Languages
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="/samanta_crm/languages/<?= $language['id'] ?>/update">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="code" class="form-label">Language Code</label>
                        <input type="text" 
                               class="form-control" 
                               id="code" 
                               name="code" 
                               value="<?= htmlspecialchars($language['code']) ?>"
                               readonly>
                        <div class="form-text">Language code cannot be changed</div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name" class="form-label">Name *</label>
                        <input type="text" 
                               class="form-control" 
                               id="name" 
                               name="name" 
                               value="<?= htmlspecialchars($language['name']) ?>"
                               required>
                        <div class="form-text">Language name in English</div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="native_name" class="form-label">Native Name</label>
                        <input type="text" 
                               class="form-control" 
                               id="native_name" 
                               name="native_name"
                               value="<?= htmlspecialchars($language['native_name']) ?>">
                        <div class="form-text">Language name in its own language</div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="flag" class="form-label">Flag</label>
                        <input type="text" 
                               class="form-control" 
                               id="flag" 
                               name="flag" 
                               maxlength="10"
                               value="<?= htmlspecialchars($language['flag']) ?>">
                        <div class="form-text">Flag emoji or symbol</div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-check mb-3">
                        <input class="form-check-input" 
                               type="checkbox" 
                               id="is_active" 
                               name="is_active" 
                               value="1"
                               <?= $language['is_active'] ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_active">
                            Active
                        </label>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-check mb-3">
                        <input class="form-check-input" 
                               type="checkbox" 
                               id="is_default" 
                               name="is_default" 
                               value="1"
                               <?= $language['is_default'] ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_default">
                            Default Language
                        </label>
                        <div class="form-text">Set as default language (will unset current default)</div>
                    </div>
                </div>
            </div>
            
            <div class="d-flex justify-content-between">
                <a href="/samanta_crm/languages" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update Language
                </button>
            </div>
        </form>
    </div>
</div>

<div class="card mt-3">
    <div class="card-body">
        <h6 class="card-title text-muted">Language Information</h6>
        <p><strong>ID:</strong> <?= $language['id'] ?></p>
        <p><strong>Created:</strong> <?= date('F j, Y g:i A', strtotime($language['created_at'])) ?></p>
        <?php if ($language['updated_at']): ?>
        <p><strong>Last Updated:</strong> <?= date('F j, Y g:i A', strtotime($language['updated_at'])) ?></p>
        <?php endif; ?>
        
        <hr>
        
        <div class="d-flex gap-2">
            <a href="/samanta_crm/languages/<?= $language['id'] ?>/translations" class="btn btn-outline-primary">
                <i class="fas fa-language"></i> Manage Translations
            </a>
        </div>
    </div>
</div>

<?php 
$content = ob_get_clean();
include '../app/Views/layout.php'; 
?>
  