<?php 
$title = 'Create Language';
ob_start(); 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">
        <i class="fas fa-plus"></i> Create New Language
    </h1>
    <a href="/samanta_crm/languages" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Languages
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="/samanta_crm/languages">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="code" class="form-label">Language Code *</label>
                        <input type="text" 
                               class="form-control" 
                               id="code" 
                               name="code" 
                               maxlength="2"
                               pattern="[a-z]{2}"
                               required>
                        <div class="form-text">2-letter ISO language code (e.g., en, es, fr)</div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name" class="form-label">Name *</label>
                        <input type="text" 
                               class="form-control" 
                               id="name" 
                               name="name" 
                               required>
                        <div class="form-text">Language name in English</div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="native_name" class="form-label">Native Name</label>
                        <input type="text" 
                               class="form-control" 
                               id="native_name" 
                               name="native_name">
                        <div class="form-text">Language name in its own language</div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="flag" class="form-label">Flag</label>
                        <input type="text" 
                               class="form-control" 
                               id="flag" 
                               name="flag" 
                               maxlength="10">
                        <div class="form-text">Flag emoji or symbol</div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-check mb-3">
                        <input class="form-check-input" 
                               type="checkbox" 
                               id="is_active" 
                               name="is_active" 
                               value="1"
                               checked>
                        <label class="form-check-label" for="is_active">
                            Active
                        </label>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-check mb-3">
                        <input class="form-check-input" 
                               type="checkbox" 
                               id="is_default" 
                               name="is_default" 
                               value="1">
                        <label class="form-check-label" for="is_default">
                            Default Language
                        </label>
                        <div class="form-text">Set as default language (will unset current default)</div>
                    </div>
                </div>
            </div>
            
            <div class="d-flex justify-content-between">
                <a href="/samanta_crm/languages" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Create Language
                </button>
            </div>
        </form>
    </div>
</div>

<?php 
$content = ob_get_clean();
$scripts = '
<script>
// Auto-convert code to lowercase
document.getElementById("code").addEventListener("input", function() {
    this.value = this.value.toLowerCase();
});
</script>
';
include '../app/Views/layout.php'; 
?>
