<?php $title=__('ingredients.add_ingredient', 'Add Ingredient'); ob_start(); ?>
<h3><?= __('ingredients.add_ingredient', 'Add Ingredient') ?></h3>
<form method="POST" action="/samanta_crm/ingredients">
  <div class="mb-2">
    <label class="form-label"><?= __('common.name', 'Name') ?> *</label>
    <input name="name" class="form-control form-control-sm" required>
  </div>
  <div class="mb-2">
    <label class="form-label"><?= __('common.unit', 'Unit') ?></label>
    <select name="unit_code" class="form-select form-select-sm">
      <option value=""><?= __('common.none', '-- None --') ?></option>
      <?php foreach(($units??[]) as $u): ?>
        <option value="<?= htmlspecialchars($u['code']) ?>"><?= htmlspecialchars($u['name']) ?> (<?= htmlspecialchars($u['code']) ?>)</option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-2">
    <label class="form-label"><?= __('ingredients.supplier', 'Supplier') ?></label>
    <input name="supplier" class="form-control form-control-sm" placeholder="<?= __('ingredients.supplier_placeholder', 'Supplier name') ?>">
  </div>
  <div class="mb-2">
    <label class="form-label"><?= __('ingredients.notes', 'Notes') ?></label>
    <textarea name="notes" class="form-control form-control-sm" rows="2"></textarea>
  </div>
  
  <div class="card mb-3">
    <div class="card-header py-2 small fw-bold">
      <i class="fas fa-exclamation-triangle me-1"></i><?= __('ingredients.stock_levels', 'Stock Level Alerts') ?>
    </div>
    <div class="card-body">
      <div class="row g-2">
        <div class="col-md-6">
          <label class="form-label small"><?= __('ingredients.critical_low_stock', 'Critical Low Stock') ?></label>
          <input type="number" step="0.01" name="critical_low_stock" class="form-control form-control-sm" placeholder="<?= __('ingredients.critical_low_hint', 'Alert when below this level') ?>">
          <div class="form-text"><?= __('ingredients.critical_low_desc', 'Urgent restock needed') ?></div>
        </div>
        <div class="col-md-6">
          <label class="form-label small"><?= __('ingredients.low_stock', 'Low Stock') ?></label>
          <input type="number" step="0.01" name="low_stock" class="form-control form-control-sm" placeholder="<?= __('ingredients.low_stock_hint', 'Warning level') ?>">
          <div class="form-text"><?= __('ingredients.low_stock_desc', 'Should restock soon') ?></div>
        </div>
        <div class="col-md-6">
          <label class="form-label small"><?= __('ingredients.high_stock', 'High Stock') ?></label>
          <input type="number" step="0.01" name="high_stock" class="form-control form-control-sm" placeholder="<?= __('ingredients.high_stock_hint', 'Warning level') ?>">
          <div class="form-text"><?= __('ingredients.high_stock_desc', 'Stock above normal') ?></div>
        </div>
        <div class="col-md-6">
          <label class="form-label small"><?= __('ingredients.critical_high_stock', 'Critical High Stock') ?></label>
          <input type="number" step="0.01" name="critical_high_stock" class="form-control form-control-sm" placeholder="<?= __('ingredients.critical_high_hint', 'Alert when above this level') ?>">
          <div class="form-text"><?= __('ingredients.critical_high_desc', 'Overstocked - risk of waste') ?></div>
        </div>
      </div>
    </div>
  </div>
  
  <button class="btn btn-primary"><?= __("common.save", "Save") ?></button> <a href="/samanta_crm/ingredients" class="btn btn-secondary"><?= __("common.cancel", "Cancel") ?></a>
</form>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
