<?php
require_once __DIR__ . '/../../../bootstrap/auth.php';
requireLogin();
ob_start();
$title='Export / Import';
?>
<div class="content">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-file-export me-2"></i>Export / Import</h2>
    <a href="/samanta_crm/dashboard" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left"></i> Back</a>
  </div>
  <div class="row g-4">
    <div class="col-md-6">
      <div class="card h-100">
        <div class="card-header"><strong>Export Data</strong></div>
        <div class="card-body">
          <p class="text-muted small">Download current languages and translations in JSON or CSV format.</p>
          <div class="mb-3">
            <h6>Languages</h6>
            <a href="/samanta_crm/export/languages?format=json" class="btn btn-sm btn-outline-primary me-2"><i class="fas fa-download"></i> JSON</a>
            <a href="/samanta_crm/export/languages?format=csv" class="btn btn-sm btn-outline-primary"><i class="fas fa-download"></i> CSV</a>
          </div>
          <div class="mb-3">
            <h6>Translations</h6>
            <a href="/samanta_crm/export/translations?format=json" class="btn btn-sm btn-outline-success me-2"><i class="fas fa-download"></i> JSON</a>
            <a href="/samanta_crm/export/translations?format=csv" class="btn btn-sm btn-outline-success"><i class="fas fa-download"></i> CSV</a>
          </div>
          <div class="alert alert-info small mb-0"><i class="fas fa-info-circle"></i> JSON keeps structure; CSV is better for spreadsheets.</div>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card h-100">
        <div class="card-header"><strong>Import Data</strong></div>
        <div class="card-body">
          <p class="text-muted small">Upload previously exported files. Existing keys / codes will be updated; new ones created.</p>
          <form class="mb-3" method="POST" action="/samanta_crm/import/languages" enctype="multipart/form-data">
            <label class="form-label">Import Languages (JSON or CSV)</label>
            <input type="file" name="file" accept=".json,.csv" class="form-control mb-2" required>
            <button class="btn btn-sm btn-primary"><i class="fas fa-upload"></i> Import Languages</button>
          </form>
          <form method="POST" action="/samanta_crm/import/translations" enctype="multipart/form-data">
            <label class="form-label">Import Translations (JSON or CSV)</label>
            <input type="file" name="file" accept=".json,.csv" class="form-control mb-2" required>
            <button class="btn btn-sm btn-success"><i class="fas fa-upload"></i> Import Translations</button>
          </form>
          <div class="alert alert-warning small mt-3"><i class="fas fa-exclamation-triangle"></i> Imports don't delete existing entries; empty values are skipped.</div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $content = ob_get_clean(); include __DIR__ . '/../layout.php'; ?>
