<?php 
$title = __('nav.dashboard', 'Dashboard');
ob_start(); 
?>

<div class="row">
    <div class="col-12">
        <h1 class="h3 mb-4">
            <i class="fas fa-tachometer-alt"></i> <?= __('nav.dashboard', 'Dashboard') ?>
        </h1>
    </div>
</div>

<div class="row" id="dashboardStats">
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4><?= $pendingOrders ?></h4>
                        <p class="mb-0"><?= __('dashboard.pending_orders', 'Pending Orders') ?></p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-clock fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4><?= $totalOrders ?></h4>
                        <p class="mb-0"><?= __('dashboard.total_orders', 'Total Orders') ?></p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-shopping-cart fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4><?= $ingredientStock ? round($ingredientStock['total_stock']) : 0 ?> <small><?= htmlspecialchars($ingredientStock['unit']) ?></small></h4>
                        <p class="mb-0">
                            <?= $ingredientStock ? htmlspecialchars($ingredientStock['name']) : __('dashboard.ingredient_stock', 'Ingredient Stock') ?>
                            <?php if ($ingredientStock && $ingredientStock['unit']): ?>
                              
                            <?php endif; ?>
                        </p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-box fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4><?= $totalUsers ?></h4>
                        <p class="mb-0"><?= __('dashboard.total_users', 'Total Users') ?></p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-users fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-users"></i> <?= __('dashboard.recent_users', 'Recent Users') ?>
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($users)): ?>
                    <p class="text-muted"><?= __('dashboard.no_users_found', 'No users found.') ?></p>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th><?= __("common.name", "Name") ?></th>
                                    <th><?= __("common.email", "Email") ?></th>
                                    <th><?= __('common.role', 'Role') ?></th>
                                    <th><?= __('common.created', 'Created') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach (array_slice($users, 0, 5) as $user): ?>
                                <tr>
                                    <td><?= htmlspecialchars($user['name'] ?? '') ?></td>
                                    <td><?= htmlspecialchars($user['email'] ?? '') ?></td>
                                    <td>
                                        <span class="badge bg-<?= ($user['role'] ?? '') === 'admin' ? 'danger' : 'primary' ?>">
                                            <?= isset($user['role']) ? ucfirst($user['role']) : '' ?>
                                        </span>
                                    </td>
                                    <td><?= isset($user['created_at']) ? date('M j, Y', strtotime($user['created_at'])) : '' ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="text-center">
                        <a href="/samanta_crm/users" class="btn btn-outline-primary">
                            <?= __('dashboard.view_all_users', 'View All Users') ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
       
            <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-cogs"></i> <?= __('dashboard.quick_actions', 'Quick Actions') ?>
                </h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="/samanta_crm/users/create" class="btn btn-primary">
                        <i class="fas fa-plus"></i> <?= __('dashboard.add_user', 'Add User') ?>
                    </a>
                    <a href="/samanta_crm/users" class="btn btn-outline-primary">
                        <i class="fas fa-list"></i> <?= __('dashboard.manage_users', 'Manage Users') ?>
                    </a>
                    <?php if ($_SESSION['user_role'] === 'admin'): ?>
                    <a href="/samanta_crm/user-types" class="btn btn-outline-secondary">
                        <i class="fas fa-tags"></i> <?= __('nav.user_types', 'User Types') ?>
                    </a>
                    <hr class="my-2">
                    <a href="/samanta_crm/products" class="btn btn-outline-success">
                        <i class="fas fa-boxes"></i> <?= __('dashboard.products', 'Products') ?>
                    </a>
                    <a href="/samanta_crm/products/import" class="btn btn-outline-success">
                        <i class="fas fa-file-import"></i> <?= __('dashboard.import_products', 'Import Products') ?>
                    </a>
                    <a href="/samanta_crm/categories" class="btn btn-outline-success">
                        <i class="fas fa-layer-group"></i> <?= __('dashboard.categories', 'Categories') ?>
                    </a>
                    <a href="/samanta_crm/ingredients" class="btn btn-outline-success">
                        <i class="fas fa-carrot"></i> <?= __('dashboard.ingredients', 'Ingredients') ?>
                    </a>
                    <a href="/samanta_crm/units" class="btn btn-outline-success">
                        <i class="fas fa-ruler-combined"></i> <?= __('dashboard.units', 'Units') ?>
                    </a>
                    <a href="/samanta_crm/production-sites" class="btn btn-outline-success">
                        <i class="fas fa-industry"></i> <?= __('dashboard.production_sites', 'Production Sites') ?>
                    </a>
                    <a href="/samanta_crm/report-flags" class="btn btn-outline-success">
                        <i class="fas fa-flag"></i> <?= __('dashboard.report_flags', 'Report Flags') ?>
                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php 
$content = ob_get_clean();
include '../app/Views/layout.php'; 
?>
