<?php $title='Customers'; ob_start(); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 mb-0"><i class="fas fa-user-group me-2"></i> Customers</h1>
  <a href="/samanta_crm/customers/create" class="btn btn-sm btn-primary"><i class="fas fa-plus"></i> New</a>
</div>
<table class="table table-striped table-sm align-middle">
  <thead>
    <tr><th><?= __("common.name", "Name") ?></th><th><?= __("common.email", "Email") ?></th><th>Phone</th><th><?= __("common.status", "Status") ?></th><th style="width:140px"><?= __("common.actions", "Actions") ?></th></tr>
  </thead>
  <tbody>
  <?php foreach($customers as $c): ?>
    <tr>
      <td><?= htmlspecialchars($c['name']) ?></td>
      <td><?= htmlspecialchars($c['email']) ?></td>
      <td><?= htmlspecialchars($c['phone']) ?></td>
      <td><span class="badge bg-<?= $c['status']==='active'?'success':'secondary' ?>"><?= htmlspecialchars($c['status']) ?></span></td>
      <td>
        <a class="btn btn-sm btn-outline-secondary" href="/samanta_crm/customers/<?= $c['id'] ?>/edit"><i class="fas fa-edit"></i></a>
        <form action="/samanta_crm/customers/<?= $c['id'] ?>/delete" method="POST" class="d-inline" onsubmit="return confirm('Delete customer?')">
          <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
        </form>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
<?php $content=ob_get_clean(); require_once __DIR__.'/../layout.php'; ?>
